﻿---
title: Elastic Jira connector reference
description: The Elastic Jira connector is a connector for Atlassian Jira. This connector is written in Python using the Elastic connector framework. View the source...
url: https://www.elastic.co/docs/reference/search-connectors/es-connectors-jira
products:
  - Elasticsearch
---

# Elastic Jira connector reference
The *Elastic Jira connector* is a [connector](https://www.elastic.co/docs/reference/search-connectors) for [Atlassian Jira](https://www.atlassian.com/software/jira). This connector is written in Python using the [Elastic connector framework](https://github.com/elastic/connectors/tree/main).
View the [**source code** for this connector](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/atlassian/jira) (branch *main*, compatible with Elastic *9.0*).

## **Self-managed connector**


### Availability and prerequisites

This connector is available as a self-managed connector. This self-managed connector is compatible with Elastic versions **8.7.0+**.
<note>
  Jira Data Center support was added in 8.13.0 in technical preview and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Technical preview features are not subject to the support SLA of official GA features.
</note>

To use this connector, satisfy all [self-managed connector requirements](https://www.elastic.co/docs/reference/search-connectors/self-managed-connectors).

### Create a Jira connector


#### Use the UI

To create a new Jira connector:
1. In the Kibana UI, search for "connectors" using the [global search field](https://www.elastic.co/docs/explore-analyze/query-filter/filtering#_finding_your_apps_and_objects) and choose the "Elasticsearch" connectors.
2. Follow the instructions to create a new  **Jira** self-managed connector.


#### Use the API

You can use the Elasticsearch [Create connector API](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-connector) to create a new self-managed Jira self-managed connector.
For example:
```json

{
  "index_name": "my-elasticsearch-index",
  "name": "Content synced from Jira",
  "service_type": "jira"
}
```

<dropdown title="You’ll also need to create an API key for the connector to use.">
  <note>
    The user needs the cluster privileges `manage_api_key`, `manage_connector` and `write_connector_secrets` to generate API keys programmatically.
  </note>
  To create an API key for the connector:
  1. Run the following command, replacing values where indicated. Note the `encoded` return values from the response:
     ```json

     {
       "name": "connector_name-connector-api-key",
       "role_descriptors": {
         "connector_name-connector-role": {
           "cluster": [
             "monitor",
             "manage_connector"
           ],
           "indices": [
             {
               "names": [
                 "index_name",
                 ".search-acl-filter-index_name",
                 ".elastic-connectors*"
               ],
               "privileges": [
                 "all"
               ],
               "allow_restricted_indices": false
             }
           ]
         }
       }
     }
     ```
  2. Update your `config.yml` file with the API key `encoded` value.
</dropdown>

Refer to the [Elasticsearch API documentation](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-connector) for details of all available Connector APIs.

### Usage

To use this connector as a **self-managed connector**, see [*Self-managed connectors*](https://www.elastic.co/docs/reference/search-connectors/self-managed-connectors) For additional usage operations, see [*Connectors UI in Kibana*](https://www.elastic.co/docs/reference/search-connectors/connectors-ui-in-kibana).

### Compatibility

- Jira Cloud, Jira Server, and Jira Data Center **versions 7 or later**.


### Configuration

The following configuration fields are required to set up the connector:
<definitions>
  <definition term="data_source">
    Dropdown to determine the Jira platform type: `Jira Cloud`, `Jira Server`, or `Jira Data Center`. Default value is `Jira Cloud`.
  </definition>
  <definition term="data_center_username">
    The username of the account for Jira Data Center.
  </definition>
  <definition term="data_center_password">
    The password of the account to be used for Jira Data Center.
  </definition>
  <definition term="username">
    The username of the account for Jira Server.
  </definition>
  <definition term="password">
    The password of the account to be used for Jira Server.
  </definition>
  <definition term="account_email">
    Email address to authenticate with Jira Cloud. Example: `jane.doe@example.com`
  </definition>
  <definition term="api_token">
    The API Token to authenticate with Jira Cloud.
  </definition>
  <definition term="jira_url">
    The domain where Jira is hosted. Examples:
    - [https://192.158.1.38:8080/](https://192.158.1.38:8080/)
    - [[https://test_user.atlassian.net/](https://test_user.atlassian.net/)](https://test_user.atlassian.net/)
  </definition>
  <definition term="projects">
    Comma-separated list of [Project Keys](https://support.atlassian.com/jira-software-cloud/docs/what-is-an-issue/#Workingwithissues-Projectkeys) to fetch data from Jira server or cloud. If the value is `*` the connector will fetch data from all projects present in the configured projects. Default value is `*`. Examples:
    - `EC`, `TP`
    - `*`
    This field can be bypassed by advanced sync rules.
  </definition>
  <definition term="ssl_enabled">
    Whether SSL verification will be enabled. Default value is `False`.
  </definition>
  <definition term="ssl_ca">
    Content of SSL certificate. Note: In case of `ssl_enabled` is `False`, the `ssl_ca` value will be ignored. Example certificate:
    ```txt
    -----BEGIN CERTIFICATE-----
    MIID+jCCAuKgAwIBAgIGAJJMzlxLMA0GCSqGSIb3DQEBCwUAMHoxCzAJBgNVBAYT
    ...
    7RhLQyWn2u00L7/9Omw=
    -----END CERTIFICATE-----
    ```
  </definition>
  <definition term="retry_count">
    The number of retry attempts after failed request to Jira. Default value is 3.
  </definition>
  <definition term="concurrent_downloads">
    The number of concurrent downloads for fetching the attachment content. This speeds up the content extraction of attachments. Defaults to 100.
  </definition>
  <definition term="use_document_level_security">
    Toggle to enable [document level security (DLS)](https://www.elastic.co/docs/reference/search-connectors/document-level-security). When enabled, full syncs will fetch access control lists for each document and store them in the `_allow_access_control` field. Access control syncs fetch users' access control lists and store them in a separate index.
    <note>
      To access user data in Jira Administration, the account you created must be granted **Product Access** for Jira Administration. This access needs to be provided by an administrator from the [Atlassian Admin](http://admin.atlassian.com/), and the access level granted should be `Product Admin`.
    </note>
  </definition>
  <definition term="use_text_extraction_service">
    Requires a separate deployment of the [Elastic Text Extraction Service](/docs/reference/search-connectors/es-connectors-content-extraction#es-connectors-content-extraction-local). Requires that ingest pipeline settings disable text extraction. Default value is `False`.
  </definition>
</definitions>


### Deployment using Docker

You can deploy the Jira connector as a self-managed connector using Docker. Follow these instructions.
<dropdown title="Step 1: Download sample configuration file">
  Download the sample configuration file. You can either download it manually or run the following command:
  ```sh
  curl https://raw.githubusercontent.com/elastic/connectors/main/app/connectors_service/config.yml.example --output ~/connectors-config/config.yml
  ```
  Remember to update the `--output` argument value if your directory name is different, or you want to use a different config file name.
</dropdown>

<dropdown title="Step 2: Update the configuration file for your self-managed connector">
  Update the configuration file with the following settings to match your environment:
  - `elasticsearch.host`
  - `elasticsearch.api_key`
  - `connectors`
  If you’re running the connector service against a Dockerized version of Elasticsearch and Kibana, your config file will look like this:
  ```yaml
  # When connecting to your cloud deployment you should edit the host value
  elasticsearch.host: http://host.docker.internal:9200
  elasticsearch.api_key: <ELASTICSEARCH_API_KEY>

  connectors:
    -
      connector_id: <CONNECTOR_ID_FROM_KIBANA>
      service_type: jira
      api_key: <CONNECTOR_API_KEY_FROM_KIBANA>
  ```
  Using the `elasticsearch.api_key` is the recommended authentication method. However, you can also use `elasticsearch.username` and `elasticsearch.password` to authenticate with your Elasticsearch instance.Note: You can change other default configurations by simply uncommenting specific settings in the configuration file and modifying their values.
</dropdown>

<dropdown title="Step 3: Run the Docker image">
  Run the Docker image with the Connector Service using the following command:
  ```sh
  docker run \
  -v ~/connectors-config:/config \
  --network "elastic" \
  --tty \
  --rm \
  docker.elastic.co/integrations/elastic-connectors:9.3.0 \
  /app/bin/elastic-ingest \
  -c /config/config.yml
  ```
</dropdown>

Refer to [`DOCKER.md`](https://github.com/elastic/connectors/tree/main/docs/DOCKER.md) in the `elastic/connectors` repo for more details.
Find all available Docker images in the [official registry](https://www.docker.elastic.co/r/integrations/elastic-connectors).
<tip>
  We also have a quickstart self-managed option using Docker Compose, so you can spin up all required services at once: Elasticsearch, Kibana, and the connectors service. Refer to this [README](https://github.com/elastic/connectors/tree/main/scripts/stack#readme) in the `elastic/connectors` repo for more information.
</tip>


### Documents and syncs

The connector syncs the following objects and entities:
- **Projects**
  - Includes metadata such as description, project key, project type, lead name, etc.
- **Issues**
  - All types of issues including Task, Bug, Sub-task, Enhancement, Story, etc.
- Includes metadata such as issue type, parent issue details, fix versions, affected versions, resolution, attachments, comments, sub-task details, priority, custom fields, etc.
- **Attachments**

**Note:** Archived projects and issues are not indexed.
<note>
  - Content from files bigger than 10 MB won’t be extracted
  - Permissions are not synced by default. You must first enable [DLS](#es-connectors-jira-client-document-level-security). Otherwise, **all documents** indexed to an Elastic deployment will be visible to **all users with access** to that Elastic Deployment.
</note>


#### Sync types

[Full syncs](/docs/reference/search-connectors/content-syncs#es-connectors-sync-types-full) are supported by default for all connectors.
This connector also supports [incremental syncs](/docs/reference/search-connectors/content-syncs#es-connectors-sync-types-incremental).

### Sync rules

[Basic sync rules](/docs/reference/search-connectors/es-sync-rules#es-sync-rules-basic) are identical for all connectors and are available by default.
This connector supports [advanced sync rules](/docs/reference/search-connectors/es-sync-rules#es-sync-rules-advanced) for remote filtering. These rules cover complex query-and-filter scenarios that cannot be expressed with basic sync rules. Advanced sync rules are defined through a source-specific DSL JSON snippet.

#### Advanced sync rules example

**Example 1**: Queries to index content based on status of Jira issues.
```js
[
  {
    "query": "project = Collaboration AND status = 'In Progress'"
  },
  {
    "query": "status IN ('To Do', 'In Progress', 'Closed')"
  }
]
```

**Example 2**: Query to index data based on priority of issues for given projects.
```js
[
  {
    "query": "priority in (Blocker, Critical) AND project in (ProjA, ProjB, ProjC)"
  }
]
```

**Example 3**: Query to index data based on assignee and created time.
```js
[
  {
    "query": "assignee is EMPTY and created < -1d"
  }
]
```


### Document level security

Document level security (DLS) enables you to restrict access to documents based on a user’s permissions. Refer to [configuration](#es-connectors-jira-client-configuration) on this page for how to enable DLS for this connector.
<warning>
  Enabling DLS for your connector will cause a significant performance degradation, as the API calls to the data source required for this functionality are rate limited. This impacts the speed at which your content can be retrieved.
</warning>

<warning>
  When the `data_source` is set to Confluence Data Center or Server, the connector will only fetch 1000 users for access control syncs, due a [limitation in the API used](https://auth0.com/docs/manage-users/user-search/retrieve-users-with-get-users-endpoint#limitations).
</warning>

<note>
  Refer to [DLS in Search Applications](https://www.elastic.co/docs/reference/search-connectors/es-dls-e2e-guide) to learn how to ingest data from a connector with DLS enabled, when building a search application. The example uses SharePoint Online as the data source, but the same steps apply to every connector.
</note>


### Content Extraction

See [Content extraction](https://www.elastic.co/docs/reference/search-connectors/es-connectors-content-extraction).

### Self-managed connector operations


### End-to-end testing

The connector framework enables operators to run functional tests against a real data source. Refer to [Connector testing](/docs/reference/search-connectors/self-managed-connectors#es-build-connector-testing) for more details.
To perform E2E testing for the Jira connector, run the following command:
```shell
$ make ftest NAME=jira
```

For faster tests, add the `DATA_SIZE=small` flag:
```shell
make ftest NAME=jira DATA_SIZE=small
```


### Known issues

- **Enabling document-level security impacts performance.**
  Enabling DLS for your connector will cause a significant performance degradation, as the API calls to the data source required for this functionality are rate limited. This impacts the speed at which your content can be retrieved.

Refer to [Known issues](https://www.elastic.co/docs/release-notes/elasticsearch/known-issues) for a list of known issues for all connectors.

### Troubleshooting

See [Troubleshooting](https://www.elastic.co/docs/reference/search-connectors/es-connectors-troubleshooting).

### Security

See [Security](https://www.elastic.co/docs/reference/search-connectors/es-connectors-security).