﻿---
title: Elastic GitLab connector reference
description: The Elastic GitLab connector is a connector for GitLab. This connector is written in Python using the Elastic connector framework. View the source code...
url: https://www.elastic.co/docs/reference/search-connectors/es-connectors-gitlab
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
---

# Elastic GitLab connector reference
The *Elastic GitLab connector* is a [connector](https://www.elastic.co/docs/reference/search-connectors) for [GitLab](https://www.gitlab.com). This connector is written in Python using the [Elastic connector framework](https://github.com/elastic/connectors/tree/main).
View the [**source code** for this connector](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/gitlab) (branch *main*, compatible with Elastic *9.3*).

## **Self-managed connector**


### Availability and prerequisites

This connector is available as a self-managed connector.
This self-managed connector is compatible with Elastic versions **9.3.0+**.
To use this connector, satisfy all [self-managed connector requirements](https://www.elastic.co/docs/reference/search-connectors/self-managed-connectors).

### Create a GitLab connector


#### Use the UI

To create a new GitLab connector:
1. In the Kibana UI, search for "connectors" using the [global search field](https://www.elastic.co/docs/explore-analyze/query-filter/filtering#_finding_your_apps_and_objects) and choose the "Elasticsearch" connectors.
2. Follow the instructions to create a new  **GitLab** self-managed connector.


#### Use the API

You can use the Elasticsearch [Create connector API](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-connector) to create a new self-managed GitLab self-managed connector.
For example:
```json

{
  "index_name": "my-elasticsearch-index",
  "name": "Content synced from GitLab",
  "service_type": "gitlab"
}
```

<dropdown title="You'll also need to create an API key for the connector to use.">
  <note>
    The user needs the cluster privileges `manage_api_key`, `manage_connector` and `write_connector_secrets` to generate API keys programmatically.
  </note>
  To create an API key for the connector:
  1. Run the following command, replacing values where indicated. Note the `encoded` return values from the response:
     ```json

     {
       "name": "connector_name-connector-api-key",
       "role_descriptors": {
         "connector_name-connector-role": {
           "cluster": [
             "monitor",
             "manage_connector"
           ],
           "indices": [
             {
               "names": [
                 "index_name",
                 ".search-acl-filter-index_name",
                 ".elastic-connectors*"
               ],
               "privileges": [
                 "all"
               ],
               "allow_restricted_indices": false
             }
           ]
         }
       }
     }
     ```
  2. Update your `config.yml` file with the API key `encoded` value.
</dropdown>

Refer to the [Elasticsearch API documentation](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-connector) for details of all available Connector APIs.

### Usage

To use this connector as a **self-managed connector**, see [*Self-managed connectors*](https://www.elastic.co/docs/reference/search-connectors/self-managed-connectors) For additional usage operations, see [*Connectors UI in Kibana*](https://www.elastic.co/docs/reference/search-connectors/connectors-ui-in-kibana).

#### GitLab personal access token

Configure a GitLab personal access token to fetch data from GitLab.
Follow these steps to generate a GitLab personal access token:
- Go to **User Settings → Access Tokens** (or for project tokens: **Settings → Access Tokens → Project Access Tokens**).
- Click `Add new token`.
- Enter a token name and optional expiration date.
- Select the following scopes:
  - `api` - Required for GraphQL API access (note: the connector only performs read-only operations)
- `read_api` - Grants read access to REST API endpoints
- `read_repository` - Grants read access to repository files
- Click `Create personal access token` and copy the token.


### Compatibility

This connector supports GitLab Cloud (gitlab.com) only. GitLab Self-Managed instances are not currently supported.

### Configuration

The following configuration fields are required:
<definitions>
  <definition term="token">
    GitLab personal access token to authenticate with the GitLab instance. The token must have `api`, `read_api`, and `read_repository` scopes.
  </definition>
  <definition term="projects">
    List of project paths to sync (e.g., `group/project`, `username/project`). Use `*` or leave empty (`[]`) to sync all projects where the token's user is a member.
    Default value is `[]` (empty list, which syncs all projects).
    Examples:
    - `elastic/elasticsearch`, `elastic/kibana`
    - `*`
    - `[]` (syncs all projects)
  </definition>
</definitions>

<tip>
  **Project path format**Projects should be specified using their full path including the namespace (group or username).In the examples provided here:
  - `elastic/elasticsearch` syncs the Elasticsearch project from the elastic group
  - `elastic/kibana` syncs the Kibana project from the elastic group
</tip>


### Deployment using Docker

You can deploy the GitLab connector as a self-managed connector using Docker. Follow these instructions.
<dropdown title="Step 1: Download sample configuration file">
  Download the sample configuration file. You can either download it manually or run the following command:
  ```sh
  curl https://raw.githubusercontent.com/elastic/connectors/main/app/connectors_service/config.yml.example --output ~/connectors-config/config.yml
  ```
  Remember to update the `--output` argument value if your directory name is different, or you want to use a different config file name.
</dropdown>

<dropdown title="Step 2: Update the configuration file for your self-managed connector">
  Update the configuration file with the following settings to match your environment:
  - `elasticsearch.host`
  - `elasticsearch.api_key`
  - `connectors`
  If you're running the connector service against a Dockerized version of Elasticsearch and Kibana, your config file will look like this:
  ```yaml
  # When connecting to your cloud deployment you should edit the host value
  elasticsearch.host: http://host.docker.internal:9200
  elasticsearch.api_key: <ELASTICSEARCH_API_KEY>

  connectors:
    -
      connector_id: <CONNECTOR_ID_FROM_KIBANA>
      service_type: gitlab
      api_key: <CONNECTOR_API_KEY_FROM_KIBANA>
  ```
  Using the `elasticsearch.api_key` is the recommended authentication method. However, you can also use `elasticsearch.username` and `elasticsearch.password` to authenticate with your Elasticsearch instance.Note: You can change other default configurations by simply uncommenting specific settings in the configuration file and modifying their values.
</dropdown>

<dropdown title="Step 3: Run the Docker image">
  Run the Docker image with the Connector Service using the following command:
  ```sh
  docker run \
  -v ~/connectors-config:/config \
  --network "elastic" \
  --tty \
  --rm \
  docker.elastic.co/integrations/elastic-connectors:9.3.0 \
  /app/bin/elastic-ingest \
  -c /config/config.yml
  ```
</dropdown>

Refer to [`DOCKER.md`](https://github.com/elastic/connectors/tree/main/docs/DOCKER.md) in the `elastic/connectors` repo for more details.
Find all available Docker images in the [official registry](https://www.docker.elastic.co/r/integrations/elastic-connectors).
<tip>
  We also have a quickstart self-managed option using Docker Compose, so you can spin up all required services at once: Elasticsearch, Kibana, and the connectors service. Refer to this [README](https://github.com/elastic/connectors/tree/main/scripts/stack#readme) in the `elastic/connectors` repo for more information.
</tip>


### Documents and syncs

The connector syncs the following objects and entities:
- **Projects**
- **Issues** (using Work Items API)
- **Merge Requests**
- **Epics** (using Work Items API, group-level, requires Premium/Ultimate tier)
- **Releases** (project-level version releases with changelogs)
- **README Files** (.md, .rst, .txt)

Only the following file extensions are ingested for README files:
- `.md`
- `.rst`
- `.txt`

<note>
  - Content of files bigger than 10 MB won't be extracted.
  - Epics are only available for Premium/Ultimate GitLab tiers and are synced at the group level.
  - **Epic syncing behavior**: Epics are fetched only for groups that contain synced projects.
  - Permissions are not synced. **All documents** indexed to an Elastic deployment will be visible to **all users with access** to that Elasticsearch Index.
</note>


#### Sync types

[Full syncs](/docs/reference/search-connectors/content-syncs#es-connectors-sync-types-full) are supported by default for all connectors.
This connector does not currently support [incremental syncs](/docs/reference/search-connectors/content-syncs#es-connectors-sync-types-incremental).

### Sync rules

*Basic* sync rules are identical for all connectors and are available by default. For more information read [Types of sync rule](/docs/reference/search-connectors/es-sync-rules#es-sync-rules-types).

#### Advanced sync rules

Advanced sync rules are not currently supported for this connector. This feature may be added in future releases.

### Content Extraction

See [Content extraction](https://www.elastic.co/docs/reference/search-connectors/es-connectors-content-extraction).

### Self-managed connector operations


### End-to-end testing

The connector framework enables operators to run functional tests against a real data source. Refer to [Connector testing](/docs/reference/search-connectors/self-managed-connectors#es-build-connector-testing) for more details.
To perform E2E testing for the GitLab connector, run the following command:
```shell
$ make ftest NAME=gitlab
```

For faster tests, add the `DATA_SIZE=small` flag:
```shell
make ftest NAME=gitlab DATA_SIZE=small
```


### Known issues

There are currently no known issues for this connector. Refer to [Known issues](https://www.elastic.co/docs/release-notes/elasticsearch/known-issues) for a list of known issues for all connectors.

### Troubleshooting

See [Troubleshooting](https://www.elastic.co/docs/reference/search-connectors/es-connectors-troubleshooting).

### Security

See [Security](https://www.elastic.co/docs/reference/search-connectors/es-connectors-security).