﻿---
title: Document level security for content connectors
description: Document level security (DLS) enables you to restrict access to documents in your Elasticsearch indices according to user and group permissions. This...
url: https://www.elastic.co/docs/reference/search-connectors/document-level-security
products:
  - Elasticsearch
---

# Document level security for content connectors
Document level security (DLS) enables you to restrict access to documents in your Elasticsearch indices according to user and group permissions. This ensures search results only return authorized information for users, based on their permissions.
<important>
  This page pertains to a specific implementation of DLS for Elastic content connectors.
  Refer to [Controlling access at the document and field level](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/controlling-access-at-document-field-level) to learn about the Elasticsearch DLS feature.
</important>


## Availability & prerequisites

Support for DLS in Elastic connectors was introduced in version **8.9.0**.
<note>
  This feature is in **beta** and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</note>

This feature is not available for all Elastic subscription levels. Refer to the subscriptions pages for [Elastic Cloud](https://www.elastic.co/subscriptions/cloud) and [Elastic Stack](https://www.elastic.co/subscriptions).
DLS is available by default when using the following Elastic connectors:
- [Confluence](https://www.elastic.co/docs/reference/search-connectors/es-connectors-confluence)
- [Dropbox](https://www.elastic.co/docs/reference/search-connectors/es-connectors-dropbox)
- [Jira](https://www.elastic.co/docs/reference/search-connectors/es-connectors-jira) (including Jira Data Center)
- [GitHub](https://www.elastic.co/docs/reference/search-connectors/es-connectors-github)
- [Gmail](https://www.elastic.co/docs/reference/search-connectors/es-connectors-gmail)
- [Google Drive](https://www.elastic.co/docs/reference/search-connectors/es-connectors-google-drive)
- [Network Drive](https://www.elastic.co/docs/reference/search-connectors/es-connectors-network-drive)
- [OneDrive](https://www.elastic.co/docs/reference/search-connectors/es-connectors-onedrive)
- [Outlook](https://www.elastic.co/docs/reference/search-connectors/es-connectors-outlook)
- [Salesforce](https://www.elastic.co/docs/reference/search-connectors/es-connectors-salesforce)
- [SharePoint Online](https://www.elastic.co/docs/reference/search-connectors/es-connectors-sharepoint-online)
- [SharePoint Server](https://www.elastic.co/docs/reference/search-connectors/es-connectors-sharepoint)
- [ServiceNow](https://www.elastic.co/docs/reference/search-connectors/es-connectors-servicenow)

Note that our standalone products (App Search and Workplace Search) do not use this feature. Workplace Search has its own permissions management system.

## Learn more about DLS for content connectors

DLS documentation:
- [How DLS works](https://www.elastic.co/docs/reference/search-connectors/es-dls-overview)
- [DLS in Search Applications](https://www.elastic.co/docs/reference/search-connectors/es-dls-e2e-guide)
- [DLS for SharePoint Online connector](/docs/reference/search-connectors/es-connectors-sharepoint-online#es-connectors-sharepoint-online-client-configuration)