﻿---
title: Content syncs
description: Elastic connectors have two types of content syncs: Full syncs, Incremental syncs. A full sync syncs all documents in the third-party data source into...
url: https://www.elastic.co/docs/reference/search-connectors/content-syncs
products:
  - Elasticsearch
---

# Content syncs
Elastic connectors have two types of content syncs:
- [Full syncs](#es-connectors-sync-types-full)
- [Incremental syncs](#es-connectors-sync-types-incremental)


## Full syncs

<note>
  We recommend running a full sync whenever [Sync rules](https://www.elastic.co/docs/reference/search-connectors/es-sync-rules) are modified
</note>

A full sync syncs all documents in the third-party data source into Elasticsearch.
It also deletes any documents in Elasticsearch, which no longer exist in the third-party data source.
A full sync, by definition, takes longer than an incremental sync but it ensures full data consistency.
A full sync is available for all connectors.
You can [schedule](/docs/reference/search-connectors/connectors-ui-in-kibana#es-connectors-usage-syncs-recurring) or [manually trigger](/docs/reference/search-connectors/connectors-ui-in-kibana#es-connectors-usage-syncs-manual) a full sync job.

## Incremental syncs

An incremental sync only syncs data changes since the last full or incremental sync.
Incremental syncs are only available after an initial full sync has successfully completed. Otherwise the incremental sync will fail.
You can [schedule](/docs/reference/search-connectors/connectors-ui-in-kibana#es-connectors-usage-syncs-recurring) or [manually trigger](/docs/reference/search-connectors/connectors-ui-in-kibana#es-connectors-usage-syncs-manual) an incremental sync job.

### Incremental sync performance

During an incremental sync your connector will still *fetch* all data from the third-party data source. If data contains timestamps, the connector framework compares document ids and timestamps. If a document already exists in Elasticsearch with the same timestamp, then this document does not need updating and will not be sent to Elasticsearch.
The determining factor in incremental sync performance is the raw volume of data ingested. For small volumes of data, the performance improvement using incremental syncs will be negligible. For large volumes of data, the performance impact can be huge. Additionally, an incremental sync is less likely to be throttled by Elasticsearch, making it more performant than a full sync when Elasticsearch is under heavy load.
A third-party data source that has throttling and low throughput, but stores very little data in Elasticsearch, such as GitHub, Jira, or Confluence, won’t see a significant performance improvement from incremental syncs.
However, a fast, accessible third-party data source that stores huge amounts of data in Elasticsearch, such as Azure Blob Storage, Google Drive, or S3, can lead to a significant performance improvement from incremental syncs.
<note>
  Incremental syncs for [SharePoint Online](https://www.elastic.co/docs/reference/search-connectors/es-connectors-sharepoint-online) and [Google Drive](https://www.elastic.co/docs/reference/search-connectors/es-connectors-google-drive) connectors use specific logic. All other connectors use the same shared connector framework logic for incremental syncs.
</note>


### Incremental sync availability

Incremental syncs are available for the following connectors:
- [Azure Blob Storage](https://www.elastic.co/docs/reference/search-connectors/es-connectors-azure-blob)
- [Box](https://www.elastic.co/docs/reference/search-connectors/es-connectors-box)
- [Confluence](https://www.elastic.co/docs/reference/search-connectors/es-connectors-confluence)
- [Dropbox](https://www.elastic.co/docs/reference/search-connectors/es-connectors-dropbox)
- [GitHub](https://www.elastic.co/docs/reference/search-connectors/es-connectors-github)
- [Gmail](https://www.elastic.co/docs/reference/search-connectors/es-connectors-gmail)
- [Google Cloud Storage](https://www.elastic.co/docs/reference/search-connectors/es-connectors-google-cloud)
- [Google Drive](https://www.elastic.co/docs/reference/search-connectors/es-connectors-google-drive)
- [Jira](https://www.elastic.co/docs/reference/search-connectors/es-connectors-jira)
- [Network drive](https://www.elastic.co/docs/reference/search-connectors/es-connectors-network-drive)
- [Notion](https://www.elastic.co/docs/reference/search-connectors/es-connectors-notion)
- [OneDrive](https://www.elastic.co/docs/reference/search-connectors/es-connectors-onedrive)
- [Outlook](https://www.elastic.co/docs/reference/search-connectors/es-connectors-outlook)
- [Salesforce](https://www.elastic.co/docs/reference/search-connectors/es-connectors-salesforce)
- [ServiceNow](https://www.elastic.co/docs/reference/search-connectors/es-connectors-servicenow)
- [SharePoint Online](https://www.elastic.co/docs/reference/search-connectors/es-connectors-sharepoint-online)
- [SharePoint Server](https://www.elastic.co/docs/reference/search-connectors/es-connectors-sharepoint)
- [Teams](https://www.elastic.co/docs/reference/search-connectors/es-connectors-teams)
- [Zoom](https://www.elastic.co/docs/reference/search-connectors/es-connectors-zoom)