﻿---
title: Content connectors
description: A connector is an Elastic integration that syncs data from an original data source to Elasticsearch. Use connectors to create searchable, read-only replicas...
url: https://www.elastic.co/docs/reference/search-connectors
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Content connectors
<note>
  This page is about Content connectors that synchronize third-party data into Elasticsearch. If you’re looking for Kibana connectors to integrate with services like generative AI model providers, refer to [Kibana Connectors](https://www.elastic.co/docs/deploy-manage/manage-connectors).
</note>

A _connector_ is an Elastic integration that syncs data from an original data source to Elasticsearch. Use connectors to create searchable, read-only replicas of your data in Elasticsearch.
Each connector extracts the original files, records, or objects; and transforms them into documents within Elasticsearch.
These connectors are written in Python and the source code is available in the [`elastic/connectors`](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources) repo.

## Setup modes

You can set up content connectors in two ways. The availability of each setup mode is indicated on the interface of your Kibana **Content connectors** page.

|                      | **[Self-managed](https://www.elastic.co/docs/reference/search-connectors/self-managed-connectors)** | **Elastic managed**                                                                                                                                                                   |
|----------------------|-----------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **Infrastructure**   | You deploy the connector service                                                                    | Elastic hosts it for you                                                                                                                                                              |
| **Availability**     | Any Elastic environment                                                                             | Elastic Cloud only (Elastic Cloud Hosted/Serverless), for Elastic Observability and [Elastic Security](https://www.elastic.co/docs/solutions/security/get-started/content-connectors) |
| **Can send data to** | Any Elasticsearch instance                                                                          | Deployment or project the connector is deployed within only                                                                                                                           |
| **Customization**    | Supported                                                                                           | Not supported                                                                                                                                                                         |


## Available connectors

This table provides an overview of our available connectors, their current support status, and the features they support.
The columns provide specific information about each connector:
- **Status**: Indicates whether the connector is in General Availability (GA), Technical Preview, Beta, or is an Example connector.
- **Advanced sync rules**: Specifies the versions in which advanced sync rules are supported, if applicable.
- **Local binary extraction service**: Specifies the versions in which the local binary extraction service is supported, if applicable.
- **Incremental syncs**: Specifies the version in which incremental syncs are supported, if applicable.
- **Document level security**: Specifies the version in which document level security is supported, if applicable.


| Connector                                                                                                    | Status      | [Advanced sync rules](/docs/reference/search-connectors/es-sync-rules#es-sync-rules-advanced) | [Local binary extraction service](/docs/reference/search-connectors/es-connectors-content-extraction#es-connectors-content-extraction-local) | [Incremental syncs](/docs/reference/search-connectors/content-syncs#es-connectors-sync-types-incremental) | [Document level security](https://www.elastic.co/docs/reference/search-connectors/document-level-security) | Source code                                                                                                                         |
|--------------------------------------------------------------------------------------------------------------|-------------|-----------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------|
| [Azure Blob](https://www.elastic.co/docs/reference/search-connectors/es-connectors-azure-blob)               | **GA**      | -                                                                                             | 8.11+                                                                                                                                        | 8.13+                                                                                                     | -                                                                                                          | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/azure_blob_storage/)          |
| [Box](https://www.elastic.co/docs/reference/search-connectors/es-connectors-box)                             | **Preview** | -                                                                                             | -                                                                                                                                            | 8.13+                                                                                                     | -                                                                                                          | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/box)                          |
| [Confluence Cloud](https://www.elastic.co/docs/reference/search-connectors/es-connectors-confluence)         | **GA**      | 8.9+                                                                                          | 8.11+                                                                                                                                        | 8.13+                                                                                                     | 8.10                                                                                                       | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/atlassian/confluence)         |
| [Confluence Data Center](https://www.elastic.co/docs/reference/search-connectors/es-connectors-confluence)   | **Preview** | 8.13+                                                                                         | 8.13+                                                                                                                                        | 8.13+                                                                                                     | 8.14+                                                                                                      | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/atlassian/confluence)         |
| [Confluence Server](https://www.elastic.co/docs/reference/search-connectors/es-connectors-confluence)        | **GA**      | 8.9+                                                                                          | 8.11+                                                                                                                                        | 8.13+                                                                                                     | 8.14+                                                                                                      | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/atlassian/confluence)         |
| [Dropbox](https://www.elastic.co/docs/reference/search-connectors/es-connectors-dropbox)                     | **GA**      | -                                                                                             | 8.11+                                                                                                                                        | 8.13+                                                                                                     | 8.12+                                                                                                      | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/dropbox)                      |
| [GitHub](https://www.elastic.co/docs/reference/search-connectors/es-connectors-github)                       | **GA**      | 8.10+                                                                                         | 8.11+                                                                                                                                        | 8.13+                                                                                                     | 8.12+                                                                                                      | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/github)                       |
| [Gmail](https://www.elastic.co/docs/reference/search-connectors/es-connectors-gmail)                         | **GA**      | -                                                                                             | -                                                                                                                                            | 8.13+                                                                                                     | 8.10+                                                                                                      | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/gmail)                        |
| [Google Cloud Storage](https://www.elastic.co/docs/reference/search-connectors/es-connectors-google-cloud)   | **GA**      | -                                                                                             | 8.11+                                                                                                                                        | 8.13+                                                                                                     | -                                                                                                          | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/google_cloud_storage)         |
| [Google Drive](https://www.elastic.co/docs/reference/search-connectors/es-connectors-google-drive)           | **GA**      | -                                                                                             | 8.11+                                                                                                                                        | 8.13+                                                                                                     | 8.10+                                                                                                      | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/google_drive)                 |
| [GraphQL](https://www.elastic.co/docs/reference/search-connectors/es-connectors-graphql)                     | **Preview** | -                                                                                             | -                                                                                                                                            | -                                                                                                         | -                                                                                                          | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/graphql)                      |
| [Jira Cloud](https://www.elastic.co/docs/reference/search-connectors/es-connectors-jira)                     | **GA**      | 8.9+                                                                                          | 8.11+                                                                                                                                        | 8.13+                                                                                                     | 8.10+                                                                                                      | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/atlassian/jira)               |
| [Jira Data Center](https://www.elastic.co/docs/reference/search-connectors/es-connectors-jira)               | **Preview** | 8.13+                                                                                         | 8.13+                                                                                                                                        | 8.13+                                                                                                     | 8.13+*                                                                                                     | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/atlassian/jira)               |
| [Jira Server](https://www.elastic.co/docs/reference/search-connectors/es-connectors-jira)                    | **GA**      | 8.9+                                                                                          | 8.11+                                                                                                                                        | 8.13+                                                                                                     | -                                                                                                          | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/atlassian/jira)               |
| [Microsoft SQL Server](https://www.elastic.co/docs/reference/search-connectors/es-connectors-ms-sql)         | **GA**      | 8.11+                                                                                         | -                                                                                                                                            | -                                                                                                         | -                                                                                                          | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/mssql)                        |
| [MongoDB](https://www.elastic.co/docs/reference/search-connectors/es-connectors-mongodb)                     | **GA**      | 8.8 native/ 8.12 self-managed                                                                 | -                                                                                                                                            | -                                                                                                         | -                                                                                                          | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/mongo)                        |
| [MySQL](https://www.elastic.co/docs/reference/search-connectors/es-connectors-mysql)                         | **GA**      | 8.8+                                                                                          | -                                                                                                                                            | -                                                                                                         | -                                                                                                          | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/mysql)                        |
| [Network drive](https://www.elastic.co/docs/reference/search-connectors/es-connectors-network-drive)         | **GA**      | 8.10+                                                                                         | 8.14+                                                                                                                                        | 8.13+                                                                                                     | 8.11+                                                                                                      | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/network_drive)                |
| [Notion](https://www.elastic.co/docs/reference/search-connectors/es-connectors-notion)                       | **GA**      | 8.14+                                                                                         | -                                                                                                                                            | -                                                                                                         | -                                                                                                          | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/notion)                       |
| [OneDrive](https://www.elastic.co/docs/reference/search-connectors/es-connectors-onedrive)                   | **GA**      | 8.11+                                                                                         | 8.11+                                                                                                                                        | 8.13+                                                                                                     | 8.11+                                                                                                      | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/onedrive)                     |
| [Oracle](https://www.elastic.co/docs/reference/search-connectors/es-connectors-oracle)                       | **GA**      | -                                                                                             | -                                                                                                                                            | -                                                                                                         | -                                                                                                          | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/oracle)                       |
| [Outlook](https://www.elastic.co/docs/reference/search-connectors/es-connectors-outlook)                     | **GA**      | -                                                                                             | 8.11+                                                                                                                                        | 8.13+                                                                                                     | 8.14+                                                                                                      | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/outlook)                      |
| [PostgreSQL](https://www.elastic.co/docs/reference/search-connectors/es-connectors-postgresql)               | **GA**      | 8.11+                                                                                         | -                                                                                                                                            | -                                                                                                         | -                                                                                                          | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/postgresql)                   |
| [Redis](https://www.elastic.co/docs/reference/search-connectors/es-connectors-redis)                         | **Preview** | -                                                                                             | -                                                                                                                                            | -                                                                                                         | -                                                                                                          | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/redis)                        |
| [Amazon S3](https://www.elastic.co/docs/reference/search-connectors/es-connectors-s3)                        | **GA**      | 8.12+                                                                                         | 8.11+                                                                                                                                        | -                                                                                                         | -                                                                                                          | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/s3)                           |
| [Salesforce](https://www.elastic.co/docs/reference/search-connectors/es-connectors-salesforce)               | **GA**      | 8.12+                                                                                         | 8.11+                                                                                                                                        | 8.13+                                                                                                     | 8.13+                                                                                                      | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/salesforce)                   |
| [ServiceNow](https://www.elastic.co/docs/reference/search-connectors/es-connectors-servicenow)               | **GA**      | 8.10+                                                                                         | 8.11+                                                                                                                                        | 8.13+                                                                                                     | 8.13+                                                                                                      | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/servicenow)                   |
| [Sharepoint Online](https://www.elastic.co/docs/reference/search-connectors/es-connectors-sharepoint-online) | **GA**      | 8.9+                                                                                          | 8.9+                                                                                                                                         | 8.9+                                                                                                      | 8.9+                                                                                                       | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/sharepoint/sharepoint_online) |
| [Sharepoint Server](https://www.elastic.co/docs/reference/search-connectors/es-connectors-sharepoint)        | **Beta**    | -                                                                                             | 8.11+                                                                                                                                        | 8.13+                                                                                                     | 8.15+                                                                                                      | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/sharepoint/sharepoint_server) |
| [Slack](https://www.elastic.co/docs/reference/search-connectors/es-connectors-slack)                         | **Preview** | -                                                                                             | -                                                                                                                                            | -                                                                                                         | -                                                                                                          | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/slack)                        |
| [Teams](https://www.elastic.co/docs/reference/search-connectors/es-connectors-teams)                         | **Preview** | -                                                                                             | -                                                                                                                                            | 8.13+                                                                                                     | -                                                                                                          | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/microsoft_teams)              |
| [Zoom](https://www.elastic.co/docs/reference/search-connectors/es-connectors-zoom)                           | **Preview** | -                                                                                             | 8.11+                                                                                                                                        | 8.13+                                                                                                     | -                                                                                                          | [View code](https://github.com/elastic/connectors/tree/main/app/connectors_service/connectors/sources/zoom)                         |

<tip>
  Because prerequisites and configuration details vary by data source, you’ll need to refer to the individual connector references for specific details.
</tip>


## Overview

Because connectors are self-managed on your own infrastructure, they run outside of your Elastic deployment.
You can run them from source or in a Docker container.

## Workflow

In order to set up, configure, and run a connector you’ll be moving between your third-party service, the Elastic UI, and your terminal. At a high-level, the workflow looks like this:
1. Satisfy any data source prerequisites (e.g., create an OAuth application).
2. Create a connector in the UI (or via the API).
3. Deploy the connector service:
   - [Option 1: Run with Docker](https://www.elastic.co/docs/reference/search-connectors/es-connectors-run-from-docker) (recommended)
- [Option 2: Run from source](https://www.elastic.co/docs/reference/search-connectors/es-connectors-run-from-source)
4. Enter data source configuration details in the UI.


### Data source prerequisites

The first decision you need to make before deploying a connector is which third party service (data source) you want to sync to Elasticsearch. See the list of [available connectors](#available-connectors).
Note that each data source will have specific prerequisites you’ll need to meet to authorize the connector to access its data. For example, certain data sources may require you to create an OAuth application, or create a service account. You’ll need to check the [individual connector documentation](https://www.elastic.co/docs/reference/search-connectors/connector-reference) for these details.