﻿---
title: Painless scripting language
description: Painless is the default scripting language for Elasticsearch, designed for security, performance, and flexibility. Built on the Java Virtual Machine (JVM),...
url: https://www.elastic.co/docs/reference/scripting-languages/painless/painless
products:
  - Elasticsearch
  - Painless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Painless scripting language
<tip>
  This section introduces Painless syntax and advanced features. If you're new to Painless scripting, start with our [introduction](https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-painless) for fundamentals and examples.
</tip>

Painless is the default scripting language for Elasticsearch, designed for security, performance, and flexibility. Built on the [Java Virtual Machine (JVM)](https://docs.oracle.com/en/java/javase/24/vm/java-virtual-machine-technology-overview.html), Painless provides Java-like syntax with direct compilation, a sandbox environment with fine-grained allowlists, and context-aware scripting across the Elastic Stack.

## Language overview

Painless compiles directly to JVM bytecode, enabling native performance while maintaining security boundaries through fine-grained allowlists and a sandbox environment. The language implements a subset of Java syntax with Elasticsearch extensions, supporting field access patterns, datetime operations, and nested data manipulation across context-aware execution workloads.

Scripts execute within specific contexts that control available variables, allowed operations, and execution environments. Different contexts provide APIs for their specific use case.

## Core benefits

Painless provides three core benefits:
- **Security:** Fine-grained allowlists that prevent access to restricted Java APIs and enforce security layers through a sandbox environment and JVM-level protection
- **Performance:** Native compilation eliminates interpretation overhead and leverages JVM optimization, delivering native execution speed for production environments
- **Flexibility:** Scripting syntax and execution contexts span the Elasticsearch stack, from search scoring and data processing to operational processing


## Reference resources

The reference documentation includes the following resources:
- [**Language specification:**](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-language-specification) syntax, operators, data types, and compilation semantics
- [**Contexts:**](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-contexts) Execution environments, available variables, and context-specific APIs
- [**API examples:**](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-api-examples) Examples of how to run the Painless execute API to build and test scripts
- [**Debugging:**](https://www.elastic.co/docs/explore-analyze/scripting/painless-debugging) Debugging techniques, common errors, and solutions

For step-by-step tutorials and real-world examples, refer to [How to write Painless scripts](https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-using) and [Painless script tutorials](https://www.elastic.co/docs/explore-analyze/scripting/common-script-uses) in the Explore and Analyze section.