﻿---
title: Updating Fields with Painless
description: You can also easily update fields. You access the original source for a field as ctx._source.<field-name>. First, let’s look at the source data for a...
url: https://www.elastic.co/docs/reference/scripting-languages/painless/painless-walkthrough-updating-fields
products:
  - Elasticsearch
  - Painless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Updating Fields with Painless
You can also easily update fields. You access the original source for a field as `ctx._source.<field-name>`.
First, let’s look at the source data for a player by submitting the following request:
```json

{
  "query": {
    "term": {
      "_id": 1
    }
  }
}
```

To change player 1’s last name to `hockey`, simply set `ctx._source.last` to the new value:
```json

{
  "script": {
    "lang": "painless",
    "source": "ctx._source.last = params.last",
    "params": {
      "last": "hockey"
    }
  }
}
```

You can also add fields to a document. For example, this script adds a new field that contains the player’s nickname,  *hockey*.
```json

{
  "script": {
    "lang": "painless",
    "source": """
      ctx._source.last = params.last;
      ctx._source.nick = params.nick
    """,
    "params": {
      "last": "gaudreau",
      "nick": "hockey"
    }
  }
}
```