﻿---
title: Missing keys or values
description: When you access document values, using doc['myfield'].value throws an exception if the specified field is missing in a document. For more dynamic index...
url: https://www.elastic.co/docs/reference/scripting-languages/painless/painless-walkthrough-missing-keys-or-values
products:
  - Elasticsearch
  - Painless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Missing keys or values
When you access document values, using `doc['myfield'].value` throws an exception if the specified field is missing in a document.
For more dynamic index mappings, you can write a catch equation:
```
if (!doc.containsKey('myfield') || doc['myfield'].empty) { return "unavailable" } else { return doc['myfield'].value }
```

This expression tests for the existence of `myfield`, returning its value only if the key exists.
To check if a document is missing a value, call `doc['myfield'].size() == 0`.