﻿---
title: Dates
description: Date fields are exposed as ZonedDateTime, so they support methods like getYear, getDayOfWeek or, for example, getting milliseconds since epoch with getMillis...
url: https://www.elastic.co/docs/reference/scripting-languages/painless/painless-walkthrough-dates
products:
  - Elasticsearch
  - Painless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Dates
Date fields are exposed as `ZonedDateTime`, so they support methods like `getYear`, `getDayOfWeek` or, for example, getting milliseconds since epoch with `getMillis`. To use these in a script, leave out the `get` prefix and continue with lowercasing the rest of the method name. For example, the following returns every hockey player’s birth year:
```json

{
  "script_fields": {
    "birth_year": {
      "script": {
        "source": "doc.born.value.year"
      }
    }
  }
}
```

Refer to [Using datetime in Painless](https://www.elastic.co/docs/reference/scripting-languages/painless/using-datetime-in-painless) to learn more.