﻿---
title: Variables
description: Variables are containers for storing data values in your Painless scripts. Variables hold different types of data like numbers, text, lists, and other...
url: https://www.elastic.co/docs/reference/scripting-languages/painless/painless-variables
products:
  - Elasticsearch
  - Painless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Variables
Variables are containers for storing data values in your Painless scripts. Variables hold different types of data like numbers, text, lists, and other values that you can access and manipulate throughout your script.
In Painless, every variable must be declared with a specific type before you can use it. This type determines what kind of data the variable can hold and what operations you can perform on it. For example, you might use an `int` variable to store a document’s score, a `String` variable to store a field value, or a `List` variable to collect multiple results.

## Variable Types in Painless

Painless supports three main categories of variable types:
- **Primitive types** for basic data such as `int`, `double`, `boolean`, and `char`. These store simple values directly and have default values (`0` for numbers, `false` for boolean).
- **Reference types** for complex objects such as `String`, `list`, `map`, and array types like `int[]`. These store references to objects and default to `null` when not initialized.
- **Dynamic type** with `def` that can represent any type of value, determined at runtime. This provides flexibility when the exact type isn’t known in advance.

<tip>
  Painless variable types are similar to Java types. For a complete reference of available types and their specifications, refer to the [Java variables documentation](https://docs.oracle.com/javase/tutorial/java/nutsandbolts/variables.html).
</tip>


## Declaration

Before using a variable, you must declare it with the format [type](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-types) followed by an [identifier](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-identifiers). If the variable is an [array-type](/docs/reference/scripting-languages/painless/painless-types#array-type), use an opening `[` token and a closing `]` token for each dimension directly after the identifier. Specify a comma-separated list of identifiers following the type to declare multiple variables in a single statement. Use an [assignment operator](#variable-assignment) combined with a declaration to immediately assign a value to a variable. A variable not immediately assigned a value will have a default value assigned implicitly based on the type.

### Errors

- If a variable is used prior to or without declaration.


### Grammar

```
declaration : type ID assignment? (',' ID assignment?)*;
type: ID ('.' ID)* ('[' ']')*;
assignment: '=' expression;
```


### Examples

- Different variations of variable declaration
  ```java
  int x;           
  List y;          
  int x, y = 5, z; 
  def d;           
  int i = 10;      
  float[] f;       
  Map[][] m;       
  ```


## Assignment

Use the `assignment operator '='` to store a value in a variable for use in subsequent operations. Any operation that produces a value can be assigned to any variable as long as the [types](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-types) are the same or the resultant type can be [implicitly cast](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-casting) to the variable type.
**Errors**
An error if the type of value is unable to match the type of variable.
**Grammar**
```
assignment: ID '=' expression
```

**Examples**
- Variable assignment with an integer literal
  ```java
  int i;  
  i = 10; 
  ```
- Declaration combined with immediate assignment
  ```java
  int i = 10;     
  double j = 2.0; 
  ```
- Assignment of one variable to another using primitive type values
  ```java
  int i = 10; 
  int j = i;  
  ```
- Assignment with reference types using the [new instance operator](/docs/reference/scripting-languages/painless/painless-operators-reference#new-instance-operator)
  ```java
  ArrayList l = new ArrayList(); 
  Map m = new HashMap();         
  ```
- Assignment of one variable to another using reference type values
  ```java
  List l = new ArrayList(); 
  List k = l;               
  List m;                   
  m = k;                    
  ```
- Assignment with array type variables using the [new array operator](/docs/reference/scripting-languages/painless/painless-operators-array#new-array-operator).
  ```java
  int[] ia1;                   
  ia1 = new int[2];            
  ia1[0] = 1;                  
  int[] ib1 = ia1;             
  int[][] ic2 = new int[2][5]; 
  ic2[1][3] = 2;               
  ic2[0] = ia1;                
  ```