﻿---
title: Update context
description: Use a Painless script in an update operation to add, modify, or delete fields within a single document. Check out the document update tutorial for related...
url: https://www.elastic.co/docs/reference/scripting-languages/painless/painless-update-context
products:
  - Elasticsearch
  - Painless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Update context
Use a Painless script in an [update](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-update) operation to add, modify, or delete fields within a single document.
Check out the [document update tutorial](https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-document-update-tutorial) for related examples.

## Variables

<definitions>
  <definition term="params (Map, read-only)">
    User-defined parameters passed in as part of the query.
  </definition>
  <definition term="ctx['op'] (String)">
    The name of the operation.
  </definition>
  <definition term="ctx['_routing'] (String, read-only)">
    The value used to select a shard for document storage.
  </definition>
  <definition term="ctx['_index'] (String, read-only)">
    The name of the index.
  </definition>
  <definition term="ctx['_id'] (String, read-only)">
    The unique document id.
  </definition>
  <definition term="ctx['_version'] (int, read-only)">
    The current version of the document.
  </definition>
  <definition term="ctx['_now'] (long, read-only)">
    The current timestamp in milliseconds.
  </definition>
  <definition term="ctx['_source'] (Map)">
    Contains extracted JSON in a `Map` and `List` structure for the fields existing in a stored document.
  </definition>
</definitions>


## Side Effects

<definitions>
  <definition term="ctx['op']">
    Use the default of `index` to update a document. Set to `none` to specify no operation or `delete` to delete the current document from the index.
  </definition>
  <definition term="ctx['_source']">
    Modify the values in the `Map/List` structure to add, modify, or delete the fields of a document.
  </definition>
</definitions>


## Return

<definitions>
  <definition term="void">
    No expected return value.
  </definition>
</definitions>


## API

The standard [Painless API](https://www.elastic.co/guide/en/elasticsearch/painless/current/painless-api-reference-shared.html) is available.

## Example

To run the example, first [install the eCommerce sample data](/docs/reference/scripting-languages/painless/painless-context-examples#painless-sample-data-install).
The following example demonstrates how to apply a promotional discount to an order.
Find a valid document ID:
```json
GET /kibana_sample_data_ecommerce/_search
{
  "size": 1,
  "_source": false
}
```

The script performs two key actions:
1. Calculates a discounted price by subtracting $5.00 from the original `taxful_total_price.`
2. Adds the flag `discount_applied` to identify orders that received promotional pricing.

```json
POST /kibana_sample_data_ecommerce/_update/YOUR_DOCUMENT_ID
{
  "script": {
    "lang": "painless",
    "source": """
      ctx._source.discount_applied = true; 
      ctx._source.final_price = ctx._source.taxful_total_price - params.discount_amount;
      """,
    "params": {
      "discount_amount": 5.00
    }
  }
}
```