﻿---
title: Sort context
description: Use a Painless script to sort the documents in a query. The standard Painless API is available. To run the example, first install the eCommerce sample...
url: https://www.elastic.co/docs/reference/scripting-languages/painless/painless-sort-context
products:
  - Elasticsearch
  - Painless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Sort context
Use a Painless script to [sort](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/sort-search-results) the documents in a query.

## Variables

<definitions>
  <definition term="params (Map, read-only)">
    User-defined parameters passed in as part of the query.
  </definition>
  <definition term="doc (Map, read-only)">
    Contains the fields of the current document. For single-valued fields, the value can be accessed via `doc['fieldname'].value`. For multi-valued fields, this returns the first value; other values can be accessed via `doc['fieldname'].get(index)`
  </definition>
  <definition term="_score (double read-only)">
    The similarity score of the current document.
  </definition>
</definitions>


## Return

<definitions>
  <definition term="double or String">
    The sort key. The return type depends on the value of the `type` parameter in the script sort config (`"number"` or `"string"`).
  </definition>
</definitions>


## API

The standard [Painless API](https://www.elastic.co/guide/en/elasticsearch/painless/current/painless-api-reference-shared.html) is available.

## Example

To run the example, first [install the eCommerce sample data](/docs/reference/scripting-languages/painless/painless-context-examples#painless-sample-data-install).
The following request sorts documents by the average price per item, calculated by dividing the `taxful_total_price` by the `total_quantity`.
Documents with a higher average item price appear at the top of the results.
```json
GET /kibana_sample_data_ecommerce/_search
{
  "sort": {
    "_script": {
      "type": "number",
      "script": {
        "lang": "painless",
        "source": """
            doc['taxful_total_price'].value / doc['total_quantity'].value
        """
      },
      "order": "desc"
    }
  }
}
```