﻿---
title: Runtime fields context
description: Use a Painless script to calculate and emit runtime field values. Runtime fields are dynamic fields that are calculated at query time rather than being...
url: https://www.elastic.co/docs/reference/scripting-languages/painless/painless-runtime-fields-context
products:
  - Elasticsearch
  - Painless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Runtime fields context
Use a Painless script to calculate and emit [runtime field](https://www.elastic.co/docs/reference/scripting-languages/painless/use-painless-scripts-in-runtime-fields) values.
Runtime fields are dynamic fields that are calculated at query time rather than being indexed. This approach provides flexibility for data exploration and field creation without requiring reindexing, though it comes with performance trade-offs compared to indexed fields.
For comprehensive information about runtime field implementation and use cases, refer to the [runtime fields documentation](https://www.elastic.co/docs/manage-data/data-store/mapping/runtime-fields). You can also check the troubleshooting guide for help with runtime field exceptions.

## Methods


<definitions>
  <definition term="emit">
    (Required) Accepts the values from the script valuation. Scripts can call the `emit` method multiple times to emit multiple values.
    The `emit` method applies only to scripts used in a [runtime fields context](/docs/reference/scripting-languages/painless/painless-api-examples#painless-execute-runtime-context).
    <important>
      The `emit` method cannot accept `null` values. Do not call this method if the referenced fields do not have any values.
    </important>
  </definition>
</definitions>

<dropdown title="Signatures of emit">
  The signature for `emit` depends on the `type` of the field.
  <definitions>
    <definition term="boolean">
      `emit(boolean)`
    </definition>
    <definition term="date">
      `emit(long)`
    </definition>
    <definition term="double">
      `emit(double)`
    </definition>
    <definition term="geo_point">
      `emit(double lat, double lon)`
    </definition>
    <definition term="ip">
      `emit(String)`
    </definition>
    <definition term="long">
      `emit(long)`
    </definition>
    <definition term="keyword">
      `emit(String)`
    </definition>
  </definitions>
</dropdown>

<definitions>
  <definition term="grok">
    Defines a [grok pattern](https://www.elastic.co/docs/reference/enrich-processor/grok-processor) to extract structured fields out of a single text field within a document. A grok pattern is like a regular expression that supports aliased expressions that can be reused. See [Define a runtime field with a grok pattern](https://www.elastic.co/docs/manage-data/data-store/mapping/explore-data-with-runtime-fields#runtime-examples-grok).
    <dropdown title="Properties of grok">
      <definitions>
        <definition term="extract">
          Indicates the values to return. This method applies only to `grok` and `dissect` methods.
        </definition>
      </definitions>
    </dropdown>
  </definition>
  <definition term="dissect">
    Defines a [dissect pattern](https://www.elastic.co/docs/reference/enrich-processor/dissect-processor). Dissect operates much like grok, but does not accept regular expressions. See [Define a runtime field with a dissect pattern](https://www.elastic.co/docs/manage-data/data-store/mapping/explore-data-with-runtime-fields#runtime-examples-dissect).
    <dropdown title="Properties of dissect">
      <definitions>
        <definition term="extract">
          Indicates the values to return. This method applies only to `grok` and `dissect` methods.
        </definition>
      </definitions>
    </dropdown>
  </definition>
</definitions>


## Variables

<definitions>
  <definition term="params (Map, read-only)">
    User-defined parameters passed in as part of the query.
  </definition>
  <definition term="doc (Map, read-only)">
    Contains the fields of the specified document where each field is a `List` of values.
  </definition>
  <definition term="params['_source'] (Map, read-only)">
    Contains extracted JSON in a `Map` and `List` structure for the fields existing in a stored document.
  </definition>
</definitions>


## Return

<definitions>
  <definition term="void">
    No expected return value.
  </definition>
</definitions>


## API

Both the standard [Painless API](https://www.elastic.co/guide/en/elasticsearch/painless/current/painless-api-reference-shared.html) and specialized [Field API](https://www.elastic.co/guide/en/elasticsearch/painless/current/painless-api-reference-field.html) are available.

## Example

To run the example, first [install the eCommerce sample data](/docs/reference/scripting-languages/painless/painless-context-examples#painless-sample-data-install).
Run the following request to define a runtime field named `full_day_name`. This field contains a script that extracts the day of the week from the `order_date` field and assigns the full day name using the `dayOfWeekEnum` enumeration. The script uses the `emit` function, which is required for runtime fields.
Because `full_day_name` is a runtime field, it isn’t indexed, and the script runs dynamically at query time:
```json
PUT kibana_sample_data_ecommerce/_mapping
{
  "runtime": {
    "full_day_name": {
      "type": "keyword",
      "script": {
        "source": """emit(doc['order_date'].value.dayOfWeekEnum.getDisplayName(TextStyle.FULL, Locale.ROOT));
        """
      }
    }
  }
}
```

After defining the runtime field, you can run a query that includes a `terms` aggregation for `full_day_name`. At search time, Elasticsearch executes the script to dynamically calculate the value for each document:
```json
GET kibana_sample_data_ecommerce/_search
{
  "size": 0,
  "aggs": {
    "full_day_name": {
      "terms": {
        "field": "full_day_name",
        "size": 10
      }
    }
  }
}
```

The response includes an aggregation bucket for each time period. Elasticsearch calculates the value of the `full_day_name` field dynamically at search time, based on the `order_date` field in each document.
Response:
```json
{
  ...
  "hits": {
    "total": {
      "value": 4675,
      "relation": "eq"
    },
    "max_score": null,
    "hits": []
  },
  "aggregations": {
    "full_day_name": {
      "doc_count_error_upper_bound": 0,
      "sum_other_doc_count": 0,
      "buckets": [
        {
          "key": "Thu",
          "doc_count": 775
        },
        {
          "key": "Fri",
          "doc_count": 770
        },
        {
          "key": "Sat",
          "doc_count": 736
        },
        {
          "key": "Sun",
          "doc_count": 614
        },
        {
          "key": "Tue",
          "doc_count": 609
        },
        {
          "key": "Wed",
          "doc_count": 592
        },
        {
          "key": "Mon",
          "doc_count": 579
        }
      ]
    }
  }
}
```