﻿---
title: Operators
description: Operators are the fundamental building blocks for data manipulation in Painless scripts. They enable calculations, comparisons, logical operations, and...
url: https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators
products:
  - Elasticsearch
  - Painless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Operators
Operators are the fundamental building blocks for data manipulation in Painless scripts. They enable calculations, comparisons, logical operations, and data access across all Elasticsearch scripting [contexts](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-contexts).
An **operator** performs a specific action to evaluate values in a script. An **expression** combines one or more operators to produce a result. **Precedence** determines evaluation order when multiple operators are present, while **associativity** controls evaluation direction for operators with equal precedence.
Painless operators use Java-like syntax with Elasticsearch specific enhancements such as null-safe navigation and specialized data structure access.

## Operator categories

Painless organizes operators into five functional categories based on their purpose.
![Painless operator categories](https://www.elastic.co/docs/reference/scripting-languages/painless/images/painless-operator-categories.png)

Double-click to expand the image.
B --> B1
C --> C1
D --> D1
E --> E1
F --> F1
B1 --> B2
C1 --> C2
D1 --> D2
E1 --> E2
F1 --> F2
classDef rootNode fill:#0B64DD,stroke:#101C3F,stroke-width:2px,color:#fff
classDef categoryBox fill:#e1f5fe,stroke:#01579b,stroke-width:2px,color:#343741
classDef descBox fill:#48EFCF,stroke:#343741,stroke-width:2px,color:#343741
classDef exampleBox fill:#f5f7fa,stroke:#343741,stroke-width:2px,color:#343741
class A rootNode
class B,C,D,E,F categoryBox
class B1,C1,D1,E1,F1 descBox
class B2,C2,D2,E2,F2 exampleBox
:::
-->

### General operators

Control the fundamental flow and structure of expressions in Painless scripts. These operators manage how expressions are evaluated, values are assigned, and conditional logic is run.
- [Precedence](/docs/reference/scripting-languages/painless/painless-operators-general#precedence-operator) `()`: Controls evaluation order by overriding default precedence rules
- [Function call](/docs/reference/scripting-languages/painless/painless-operators-general#function-call-operator) `()`: Executes user-defined functions with arguments
- [Cast](/docs/reference/scripting-languages/painless/painless-operators-general#cast-operator) `()` : Forces explicit type conversion between compatible types
- [Conditional](/docs/reference/scripting-languages/painless/painless-operators-general#conditional-operator) `? :` : Provides inline if-else logic for expressions
- [Elvis](/docs/reference/scripting-languages/painless/painless-operators-reference#elvis-operator) `?:` : Returns first non-null value for null coalescing
- [Assignment](/docs/reference/scripting-languages/painless/painless-operators-general#assignment-operator) `=` : Stores values in variables or fields
- [Compound assignment](/docs/reference/scripting-languages/painless/painless-operators-general#compound-assignment-operator) `$=` : Combines binary operations with assignment (`+=`, `-=`, and so on)


### Numeric operators

Perform mathematical calculations and bit-level manipulations on numeric values. These operators handle arithmetic, bitwise operations, and value modifications essential for numerical computations.
- [Increment](/docs/reference/scripting-languages/painless/painless-operators-numeric#post-increment-operator)/[Decrement](/docs/reference/scripting-languages/painless/painless-operators-numeric#post-decrement-operator) (`++`. `--`) : Increases or decreases values by one (pre/post variants)
- [Unary](/docs/reference/scripting-languages/painless/painless-operators-numeric#unary-positive-operator) (`+`, `-`) : preserves or negates numeric values
- [Bitwise not](/docs/reference/scripting-languages/painless/painless-operators-numeric#bitwise-not-operator) `~` : inverts all bits in integer values
- [Multiplication](/docs/reference/scripting-languages/painless/painless-operators-numeric#multiplication-operator)/[Division](/docs/reference/scripting-languages/painless/painless-operators-numeric#division-operator)/[Remainder](/docs/reference/scripting-languages/painless/painless-operators-numeric#remainder-operator) `*` `/` `%` : Basic arithmetic operations
- [Addition](/docs/reference/scripting-languages/painless/painless-operators-numeric#addition-operator)/[Subtraction](/docs/reference/scripting-languages/painless/painless-operators-numeric#subtraction-operator) `+` `-` : Basic arithmetic operations
- [Shift](/docs/reference/scripting-languages/painless/painless-operators-numeric#left-shift-operator) (`<<`, `>>`, `>>>`) : Shifts bits left or right within integer values
- [Bitwise and](/docs/reference/scripting-languages/painless/painless-operators-numeric#bitwise-and-operator) `&` : Performs AND operations on corresponding bits
- [Bitwise xor](/docs/reference/scripting-languages/painless/painless-operators-numeric#bitwise-xor-operator) `^` : Performs XOR operations on corresponding bits
- [Bitwise or](/docs/reference/scripting-languages/painless/painless-operators-numeric#bitwise-or-operator) `|`: Performs OR operations on corresponding bits


### Boolean operators

Handle logical evaluation, comparisons, and conditional expressions. These operators are fundamental for creating filters, conditional logic, and boolean expressions in scripts
- [Boolean not](/docs/reference/scripting-languages/painless/painless-operators-boolean#boolean-not-operator) `!`:Inverts boolean values (true becomes false)
- [Comparison](/docs/reference/scripting-languages/painless/painless-operators-boolean#greater-than-operator) `>` `>=` `<` `<=` : Compares numeric values for ordering
- [Instanceof](/docs/reference/scripting-languages/painless/painless-operators-boolean#instanceof-operator) `instanceof`: Checks if an object is an instance of a specific type
- [Equality](/docs/reference/scripting-languages/painless/painless-operators-boolean#equality-equals-operator) `==` `!=` : Compares values for equality (calls equals() method)
- [Identity](/docs/reference/scripting-languages/painless/painless-operators-boolean#identity-equals-operator) `===` `!==` : Compares object references for same instance
- [Boolean xor](/docs/reference/scripting-languages/painless/painless-operators-boolean#boolean-xor-operator) `^`: Returns true if exactly one operand is true
- [Boolean and](/docs/reference/scripting-languages/painless/painless-operators-boolean#boolean-and-operator) `&&`: Returns true only if both operands are true
- [Boolean or](/docs/reference/scripting-languages/painless/painless-operators-boolean#boolean-or-operator) `||`: Returns true if at least one operand is true


### Reference operators

Enable interaction with objects, method calls, and data structure manipulation. These operators are essential for working with documents, collections, and complex data types in Elasticsearch contexts.
- [Method call](/docs/reference/scripting-languages/painless/painless-operators-reference#method-call-operator) `. ()`: Invokes methods on objects with optional arguments
- [Field access](/docs/reference/scripting-languages/painless/painless-operators-reference#field-access-operator) `.`: Accesses object properties and member fields
- [Null safe](/docs/reference/scripting-languages/painless/painless-operators-reference#null-safe-operator) `?.`: Safely accesses fields/methods without null pointer exceptions
- [List/Map initialization](/docs/reference/scripting-languages/painless/painless-operators-reference#list-initialization-operator) `[] [:]`: Creates new List or Map collections with initial values
- [List/Map access](/docs/reference/scripting-languages/painless/painless-operators-reference#list-access-operator) `[]`: Retrieves or sets elements in collections by key/index
- [New instance](/docs/reference/scripting-languages/painless/painless-operators-reference#new-instance-operator) `new ()`: Creates new object instances with constructor arguments
- [String concatenation](/docs/reference/scripting-languages/painless/painless-operators-reference#string-concatenation-operator) `+` : Joins strings and converts other types to strings


### Array operators

Provide specialized functionality for array creation, element access, and array property retrieval. These operators are essential when working with multi-value fields and array data structures.
- [Array initialization](/docs/reference/scripting-languages/painless/painless-operators-array#array-initialization-operator) `[] {}``: Creates arrays with predefined values
- [Array access](/docs/reference/scripting-languages/painless/painless-operators-array#array-access-operator) `[]`: Retrieves or sets array elements by index position
- [Array length](/docs/reference/scripting-languages/painless/painless-operators-array#array-length-operator) `.`: Returns the number of elements in an array
- [New array](/docs/reference/scripting-languages/painless/painless-operators-array#new-array-operator) `new []`: Creates arrays with specified dimensions and sizes


## Complete operator reference


| **Operator**                                                                                                                    | **Category**                                                                                                 | **Symbol(s)** | **Precedence** | **Associativity** |
|---------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------|---------------|----------------|-------------------|
| [Precedence](/docs/reference/scripting-languages/painless/painless-operators-general#precedence-operator)                       | [General](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-general)     | ()            | 0              | left → right      |
| [Method call](/docs/reference/scripting-languages/painless/painless-operators-reference#method-call-operator)                   | [Reference](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-reference) | . ()          | 1              | left → right      |
| [Field access](/docs/reference/scripting-languages/painless/painless-operators-reference#field-access-operator)                 | [Reference](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-reference) | .             | 1              | left → right      |
| [Null safe](/docs/reference/scripting-languages/painless/painless-operators-reference#null-safe-operator)                       | [Reference](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-reference) | ?.            | 1              | left → right      |
| [Function call](/docs/reference/scripting-languages/painless/painless-operators-general#function-call-operator)                 | [General](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-general)     | ()            | 1              | left → right      |
| [Array initialization](/docs/reference/scripting-languages/painless/painless-operators-array#array-initialization-operator)     | [Array](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-array)         | [] {}         | 1              | left → right      |
| [Array access](/docs/reference/scripting-languages/painless/painless-operators-array#array-access-operator)                     | [Array](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-array)         | []            | 1              | left → right      |
| [Array length](/docs/reference/scripting-languages/painless/painless-operators-array#array-length-operator)                     | [Array](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-array)         | .             | 1              | left → right      |
| [List initialization](/docs/reference/scripting-languages/painless/painless-operators-reference#list-initialization-operator)   | [Reference](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-reference) | []            | 1              | left → right      |
| [List access](/docs/reference/scripting-languages/painless/painless-operators-reference#list-access-operator)                   | [Reference](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-reference) | []            | 1              | left → right      |
| [Map initialization](/docs/reference/scripting-languages/painless/painless-operators-reference#map-initialization-operator)     | [Reference](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-reference) | [:]           | 1              | left → right      |
| [Map access](/docs/reference/scripting-languages/painless/painless-operators-reference#map-access-operator)                     | [Reference](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-reference) | []            | 1              | left → right      |
| [Post increment](/docs/reference/scripting-languages/painless/painless-operators-numeric#post-increment-operator)               | [Numeric](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-numeric)     | ++            | 1              | left → right      |
| [Post decrement](/docs/reference/scripting-languages/painless/painless-operators-numeric#post-decrement-operator)               | [Numeric](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-numeric)     | —             | 1              | left → right      |
| [Pre increment](/docs/reference/scripting-languages/painless/painless-operators-numeric#pre-increment-operator)                 | [Numeric](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-numeric)     | ++            | 2              | right → left      |
| [Pre decrement](/docs/reference/scripting-languages/painless/painless-operators-numeric#pre-decrement-operator)                 | [Numeric](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-numeric)     | —             | 2              | right → left      |
| [Unary positive](/docs/reference/scripting-languages/painless/painless-operators-numeric#unary-positive-operator)               | [Numeric](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-numeric)     | +             | 2              | right → left      |
| [Unary negative](/docs/reference/scripting-languages/painless/painless-operators-numeric#unary-negative-operator)               | [Numeric](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-numeric)     | -             | 2              | right → left      |
| [Boolean not](/docs/reference/scripting-languages/painless/painless-operators-boolean#boolean-not-operator)                     | [Boolean](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-boolean)     | !             | 2              | right → left      |
| [Bitwise not](/docs/reference/scripting-languages/painless/painless-operators-numeric#bitwise-not-operator)                     | [Numeric](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-numeric)     | ~             | 2              | right → left      |
| [Cast](/docs/reference/scripting-languages/painless/painless-operators-general#cast-operator)                                   | [General](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-general)     | ()            | 3              | right → left      |
| [New instance](/docs/reference/scripting-languages/painless/painless-operators-reference#new-instance-operator)                 | [Reference](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-reference) | new ()        | 3              | right → left      |
| [New array](/docs/reference/scripting-languages/painless/painless-operators-array#new-array-operator)                           | [Array](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-array)         | new []        | 3              | right → left      |
| [Multiplication](/docs/reference/scripting-languages/painless/painless-operators-numeric#multiplication-operator)               | [Numeric](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-numeric)     | *             | 4              | left → right      |
| [Division](/docs/reference/scripting-languages/painless/painless-operators-numeric#division-operator)                           | [Numeric](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-numeric)     | /             | 4              | left → right      |
| [Remainder](/docs/reference/scripting-languages/painless/painless-operators-numeric#remainder-operator)                         | [Numeric](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-numeric)     | %             | 4              | left → right      |
| [String concatenation](/docs/reference/scripting-languages/painless/painless-operators-reference#string-concatenation-operator) | [Reference](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-reference) | +             | 5              | left → right      |
| [Addition](/docs/reference/scripting-languages/painless/painless-operators-numeric#addition-operator)                           | [Numeric](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-numeric)     | +             | 5              | left → right      |
| [Subtraction](/docs/reference/scripting-languages/painless/painless-operators-numeric#subtraction-operator)                     | [Numeric](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-numeric)     | -             | 5              | left → right      |
| [Left shift](/docs/reference/scripting-languages/painless/painless-operators-numeric#left-shift-operator)                       | [Numeric](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-numeric)     | <<            | 6              | left → right      |
| [Right shift](/docs/reference/scripting-languages/painless/painless-operators-numeric#right-shift-operator)                     | [Numeric](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-numeric)     | >>            | 6              | left → right      |
| [Unsigned right shift](/docs/reference/scripting-languages/painless/painless-operators-numeric#unsigned-right-shift-operator)   | [Numeric](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-numeric)     | >>>           | 6              | left → right      |
| [Greater than](/docs/reference/scripting-languages/painless/painless-operators-boolean#greater-than-operator)                   | [Boolean](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-boolean)     | >             | 7              | left → right      |
| [Greater than Or Equal](/docs/reference/scripting-languages/painless/painless-operators-boolean#greater-than-or-equal-operator) | [Boolean](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-boolean)     | >=            | 7              | left → right      |
| [Less than](/docs/reference/scripting-languages/painless/painless-operators-boolean#less-than-operator)                         | [Boolean](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-boolean)     | <             | 7              | left → right      |
| [Less than Or Equal](/docs/reference/scripting-languages/painless/painless-operators-boolean#less-than-or-equal-operator)       | [Boolean](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-boolean)     | <=            | 7              | left → right      |
| [Instanceof](/docs/reference/scripting-languages/painless/painless-operators-boolean#instanceof-operator)                       | [Boolean](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-boolean)     | instanceof    | 8              | left → right      |
| [Equality equals](/docs/reference/scripting-languages/painless/painless-operators-boolean#equality-equals-operator)             | [Boolean](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-boolean)     | ==            | 9              | left → right      |
| [Equality not equals](/docs/reference/scripting-languages/painless/painless-operators-boolean#equality-not-equals-operator)     | [Boolean](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-boolean)     | !=            | 9              | left → right      |
| [Identity equals](/docs/reference/scripting-languages/painless/painless-operators-boolean#identity-equals-operator)             | [Boolean](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-boolean)     | ===           | 9              | left → right      |
| [Identity not equals](/docs/reference/scripting-languages/painless/painless-operators-boolean#identity-not-equals-operator)     | [Boolean](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-boolean)     | !==           | 9              | left → right      |
| [Bitwise and](/docs/reference/scripting-languages/painless/painless-operators-numeric#bitwise-and-operator)                     | [Numeric](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-numeric)     | &             | 10             | left → right      |
| [Boolean xor](/docs/reference/scripting-languages/painless/painless-operators-boolean#boolean-xor-operator)                     | [Boolean](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-boolean)     | ^             | 11             | left → right      |
| [Bitwise xor](/docs/reference/scripting-languages/painless/painless-operators-numeric#bitwise-xor-operator)                     | [Numeric](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-numeric)     | ^             | 11             | left → right      |
| [Bitwise or](/docs/reference/scripting-languages/painless/painless-operators-numeric#bitwise-or-operator)                       | [Numeric](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-numeric)     |               | 12             | left → right      |
| [Boolean and](/docs/reference/scripting-languages/painless/painless-operators-boolean#boolean-and-operator)                     | [Boolean](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-boolean)     | &&            | 13             | left → right      |
| [Boolean or](/docs/reference/scripting-languages/painless/painless-operators-boolean#boolean-or-operator)                       | [Boolean](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-boolean)     |               | 14             | left → right      |
| [Conditional](/docs/reference/scripting-languages/painless/painless-operators-general#conditional-operator)                     | [General](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-general)     | ? :           | 15             | right → left      |
| [Elvis](/docs/reference/scripting-languages/painless/painless-operators-reference#elvis-operator)                               | [General](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-general)     | ?:            | 16             | right → left      |
| [Assignment](/docs/reference/scripting-languages/painless/painless-operators-general#assignment-operator)                       | [General](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-general)     | =             | 17             | right → left      |
| [Compound assignment](/docs/reference/scripting-languages/painless/painless-operators-general#compound-assignment-operator)     | [General](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-general)     | $=            | 17             | right → left      |