﻿---
title: Operators: Boolean
description: Use the boolean not operator '!' to NOT a boolean type value where true is flipped to false and false is flipped to true. Errors If a value other than...
url: https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-boolean
products:
  - Elasticsearch
  - Painless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Operators: Boolean
## Boolean not

Use the `boolean not operator '!'` to NOT a `boolean` type value where `true` is flipped to `false` and `false` is flipped to `true`.
**Errors**
- If a value other than a `boolean` type value or a value that is castable to a `boolean` type value is given.

**Truth**

| original | result |
|----------|--------|
| true     | false  |
| false    | true   |

**Grammar**
```text
boolean_not: '!' expression;
```

**Examples**
- Boolean not with the `boolean` type
  ```java
  boolean x = !false; 
  boolean y = !x;     
  ```
- Boolean not with the `def` type
  ```java
  def y = true; 
  def z = !y;   
  ```


## Greater than

Use the `greater than operator '>'` to COMPARE two numeric type values where a resultant `boolean` type value is `true` if the left-hand side value is greater than to the right-hand side value and `false` otherwise.
**Errors**
- If either the evaluated left-hand side or the evaluated right-hand side is a non-numeric value.

**Grammar**
```text
greater_than: expression '>' expression;
```

**Promotion**

|        |        |        |        |        |        |        |        |     |
|--------|--------|--------|--------|--------|--------|--------|--------|-----|
|        | byte   | short  | char   | int    | long   | float  | double | def |
| byte   | int    | int    | int    | int    | long   | float  | double | def |
| short  | int    | int    | int    | int    | long   | float  | double | def |
| char   | int    | int    | int    | int    | long   | float  | double | def |
| int    | int    | int    | int    | int    | long   | float  | double | def |
| long   | long   | long   | long   | long   | long   | float  | double | def |
| float  | float  | float  | float  | float  | float  | float  | double | def |
| double | double | double | double | double | double | double | double | def |
| def    | def    | def    | def    | def    | def    | def    | def    | def |

**Examples**
- Greater than with different numeric types
  ```java
  boolean x = 5 > 4; 
  double y = 6.0;    
  x = 6 > y;         
  ```
- Greater than with `def` type
  ```java
  int x = 5;       
  def y = 7.0;     
  def z = y > 6.5; 
  def a = x > y;   
  ```


## Greater than or equal

Use the `greater than or equal operator '>='` to COMPARE two numeric type values where a resultant `boolean` type value is `true` if the left-hand side value is greater than or equal to the right-hand side value and `false` otherwise.
**Errors**
- If either the evaluated left-hand side or the evaluated right-hand side is a non-numeric value.

**Grammar**
```text
greater_than_or_equal: expression '>=' expression;
```

**Promotion**

|        |        |        |        |        |        |        |        |     |
|--------|--------|--------|--------|--------|--------|--------|--------|-----|
|        | byte   | short  | char   | int    | long   | float  | double | def |
| byte   | int    | int    | int    | int    | long   | float  | double | def |
| short  | int    | int    | int    | int    | long   | float  | double | def |
| char   | int    | int    | int    | int    | long   | float  | double | def |
| int    | int    | int    | int    | int    | long   | float  | double | def |
| long   | long   | long   | long   | long   | long   | float  | double | def |
| float  | float  | float  | float  | float  | float  | float  | double | def |
| double | double | double | double | double | double | double | double | def |
| def    | def    | def    | def    | def    | def    | def    | def    | def |

**Examples**
- Greater than or equal with different numeric types
  ```java
  boolean x = 5 >= 4; 
  double y = 6.0;     
  x = 6 >= y;         
  ```
- Greater than or equal with the `def` type.
  ```java
  int x = 5;        
  def y = 7.0;      
  def z = y >= 7.0; 
  def a = x >= y;   
  ```


## Less than

Use the `less than operator '<'` to COMPARE two numeric type values where a resultant `boolean` type value is `true` if the left-hand side value is less than to the right-hand side value and `false` otherwise.
**Errors**
- If either the evaluated left-hand side or the evaluated right-hand side is a non-numeric value.

**Grammar**
```text
less_than: expression '<' expression;
```

**Promotion**

|        |        |        |        |        |        |        |        |     |
|--------|--------|--------|--------|--------|--------|--------|--------|-----|
|        | byte   | short  | char   | int    | long   | float  | double | def |
| byte   | int    | int    | int    | int    | long   | float  | double | def |
| short  | int    | int    | int    | int    | long   | float  | double | def |
| char   | int    | int    | int    | int    | long   | float  | double | def |
| int    | int    | int    | int    | int    | long   | float  | double | def |
| long   | long   | long   | long   | long   | long   | float  | double | def |
| float  | float  | float  | float  | float  | float  | float  | double | def |
| double | double | double | double | double | double | double | double | def |
| def    | def    | def    | def    | def    | def    | def    | def    | def |

**Examples**
- Less than with different numeric types
  ```java
  boolean x = 5 < 4; 
  double y = 6.0;    
  x = 6 < y;         
  ```
- Less than with the `def` type.
  ```java
  int x = 5;       
  def y = 7.0;     
  def z = y < 6.5; 
  def a = x < y;   
  ```


## Less than or equal

Use the `less than or equal operator '<='` to COMPARE two numeric type values where a resultant `boolean` type value is `true` if the left-hand side value is less than or equal to the right-hand side value and `false` otherwise.
**Errors**
- If either the evaluated left-hand side or the evaluated right-hand side is a non-numeric value.

**Grammar**
```text
greater_than_or_equal: expression '<=' expression;
```

**Promotion**

|        |        |        |        |        |        |        |        |     |
|--------|--------|--------|--------|--------|--------|--------|--------|-----|
|        | byte   | short  | char   | int    | long   | float  | double | def |
| byte   | int    | int    | int    | int    | long   | float  | double | def |
| short  | int    | int    | int    | int    | long   | float  | double | def |
| char   | int    | int    | int    | int    | long   | float  | double | def |
| int    | int    | int    | int    | int    | long   | float  | double | def |
| long   | long   | long   | long   | long   | long   | float  | double | def |
| float  | float  | float  | float  | float  | float  | float  | double | def |
| double | double | double | double | double | double | double | double | def |
| def    | def    | def    | def    | def    | def    | def    | def    | def |

**Examples**
- Less than or equal with different numeric types
  ```java
  boolean x = 5 <= 4; 
  double y = 6.0;     
  x = 6 <= y;         
  ```
- Less than or equal with the `def` type.
  ```java
  int x = 5;        
  def y = 7.0;      
  def z = y <= 7.0; 
  def a = x <= y;   
  ```


## Instanceof

Use the `instanceof operator` to COMPARE the variable/field type to a specified reference type using the reference type name where a resultant `boolean` type value is `true` if the variable/field type is the same as or a descendant of the specified reference type and false otherwise.
**Errors**
- If the reference type name doesn’t exist as specified by the right-hand side.

**Grammar**
```text
instance_of: ID 'instanceof' TYPE;
```

**Examples**
- Instance of with different reference types
  ```java
  Map m = new HashMap();            
  boolean a = m instanceof HashMap; 
  boolean b = m instanceof Map;     
  ```
- Instance of with the `def` type.
  ```java
  def d = new ArrayList();       
  boolean a = d instanceof List; 
  boolean b = d instanceof Map;  
  ```


## Equality equals

Use the `equality equals operator '=='` to COMPARE two values where a resultant `boolean` type value is `true` if the two values are equal and `false` otherwise. The member method, `equals`, is implicitly called when the values are reference type values where the first value is the target of the call and the second value is the argument. This operation is null-safe where if both values are `null` the resultant `boolean` type value is `true`, and if only one value is `null` the resultant `boolean` type value is `false`. A valid comparison is between `boolean` type values, numeric type values, or reference type values.
**Errors**
- If a comparison is made between a `boolean` type value and numeric type value.
- If a comparison is made between a primitive type value and a reference type value.

**Grammar**
```text
equality_equals: expression '==' expression;
```

**Promotion**

|           |         |        |        |        |        |        |        |        |           |     |
|-----------|---------|--------|--------|--------|--------|--------|--------|--------|-----------|-----|
|           | boolean | byte   | short  | char   | int    | long   | float  | double | Reference | def |
| boolean   | boolean | -      | -      | -      | -      | -      | -      | -      | -         | def |
| byte      | -       | int    | int    | int    | int    | long   | float  | double | -         | def |
| short     | -       | int    | int    | int    | int    | long   | float  | double | -         | def |
| char      | -       | int    | int    | int    | int    | long   | float  | double | -         | def |
| int       | -       | int    | int    | int    | int    | long   | float  | double | -         | def |
| long      | -       | long   | long   | long   | long   | long   | float  | double | -         | def |
| float     | -       | float  | float  | float  | float  | float  | float  | double | -         | def |
| double    | -       | double | double | double | double | double | double | double | -         | def |
| Reference | -       | -      | -      | -      | -      | -      | -      | -      | Object    | def |
| def       | def     | def    | def    | def    | def    | def    | def    | def    | def       | def |

**Examples**
- Equality equals with the `boolean` type
  ```java
  boolean a = true;  
  boolean b = false; 
  a = a == false;    
  b = a == b;        
  ```
- Equality equals with primitive types
  ```java
  int a = 1;          
  double b = 2.0;     
  boolean c = a == b; 
  c = 1 == a;         
  ```
- Equal equals with reference types
  ```java
  List a = new ArrayList(); 
  List b = new ArrayList(); 
  a.add(1);                 
  boolean c = a == b;       
  b.add(1);                 
  c = a == b;               
  ```
- Equality equals with `null`
  ```java
  Object a = null;       
  Object b = null;       
  boolean c = a == null; 
  c = a == b;            
  b = new Object();      
  c = a == b;            
  ```
- Equality equals with the `def` type
  ```java
  def a = 0;               
  def b = 1;               
  boolean c = a == b;      
  def d = new HashMap();   
  def e = new ArrayList(); 
  c = d == e;              
  ```


## Equality not equals

Use the `equality not equals operator '!='` to COMPARE two values where a resultant `boolean` type value is `true` if the two values are NOT equal and `false` otherwise. The member method, `equals`, is implicitly called when the values are reference type values where the first value is the target of the call and the second value is the argument with the resultant `boolean` type value flipped. This operation is `null-safe` where if both values are `null` the resultant `boolean` type value is `false`, and if only one value is `null` the resultant `boolean` type value is `true`. A valid comparison is between boolean type values, numeric type values, or reference type values.
**Errors**
- If a comparison is made between a `boolean` type value and numeric type value.
- If a comparison is made between a primitive type value and a reference type value.

**Grammar**
```text
equality_not_equals: expression '!=' expression;
```

**Promotion**

|           |         |        |        |        |        |        |        |        |           |     |
|-----------|---------|--------|--------|--------|--------|--------|--------|--------|-----------|-----|
|           | boolean | byte   | short  | char   | int    | long   | float  | double | Reference | def |
| boolean   | boolean | -      | -      | -      | -      | -      | -      | -      | -         | def |
| byte      | -       | int    | int    | int    | int    | long   | float  | double | -         | def |
| short     | -       | int    | int    | int    | int    | long   | float  | double | -         | def |
| char      | -       | int    | int    | int    | int    | long   | float  | double | -         | def |
| int       | -       | int    | int    | int    | int    | long   | float  | double | -         | def |
| long      | -       | long   | long   | long   | long   | long   | float  | double | -         | def |
| float     | -       | float  | float  | float  | float  | float  | float  | double | -         | def |
| double    | -       | double | double | double | double | double | double | double | -         | def |
| Reference | -       | -      | -      | -      | -      | -      | -      | -      | Object    | def |
| def       | def     | def    | def    | def    | def    | def    | def    | def    | def       | def |

**Examples**
- Equality not equals with the `boolean` type
  ```java
  boolean a = true;  
  boolean b = false; 
  a = a != false;    
  b = a != b;        
  ```
- Equality not equals with primitive types
  ```java
  int a = 1;          
  double b = 2.0;     
  boolean c = a != b; 
  c = 1 != a;         
  ```
- Equality not equals with reference types
  ```java
  List a = new ArrayList(); 
  List b = new ArrayList(); 
  a.add(1);                 
  boolean c = a == b;       
  b.add(1);                 
  c = a == b;               
  ```
- Equality not equals with `null`
  ```java
  Object a = null;       
  Object b = null;       
  boolean c = a == null; 
  c = a == b;            
  b = new Object();      
  c = a == b;            
  ```
- Equality not equals with the `def` type
  ```java
  def a = 0;               
  def b = 1;               
  boolean c = a == b;      
  def d = new HashMap();   
  def e = new ArrayList(); 
  c = d == e;              
  ```


## Identity equals

Use the `identity equals operator '==='` to COMPARE two values where a resultant `boolean` type value is `true` if the two values are equal and `false` otherwise. A reference type value is equal to another reference type value if both values refer to same instance on the heap or if both values are `null`. A valid comparison is between `boolean` type values, numeric type values, or reference type values.
**Errors**
- If a comparison is made between a `boolean` type value and numeric type value.
- If a comparison is made between a primitive type value and a reference type value.

**Grammar**
```text
identity_equals: expression '===' expression;
```

**Promotion**

|           |         |        |        |        |        |        |        |        |           |     |
|-----------|---------|--------|--------|--------|--------|--------|--------|--------|-----------|-----|
|           | boolean | byte   | short  | char   | int    | long   | float  | double | Reference | def |
| boolean   | boolean | -      | -      | -      | -      | -      | -      | -      | -         | def |
| byte      | -       | int    | int    | int    | int    | long   | float  | double | -         | def |
| short     | -       | int    | int    | int    | int    | long   | float  | double | -         | def |
| char      | -       | int    | int    | int    | int    | long   | float  | double | -         | def |
| int       | -       | int    | int    | int    | int    | long   | float  | double | -         | def |
| long      | -       | long   | long   | long   | long   | long   | float  | double | -         | def |
| float     | -       | float  | float  | float  | float  | float  | float  | double | -         | def |
| double    | -       | double | double | double | double | double | double | double | -         | def |
| Reference | -       | -      | -      | -      | -      | -      | -      | -      | Object    | def |
| def       | def     | def    | def    | def    | def    | def    | def    | def    | def       | def |

**Examples**
- Identity equals with reference types
  ```java
  List a = new ArrayList(); 
  List b = new ArrayList(); 
  List c = a;               
  boolean c = a === b;      
  c = a === c;              
  ```
- Identity equals with `null`
  ```java
  Object a = null;        
  Object b = null;        
  boolean c = a === null; 
  c = a === b;            
  b = new Object();       
  c = a === b;            
  ```
- Identity equals with the `def` type
  ```java
  def a = new HashMap();   
  def b = new ArrayList(); 
  boolean c = a === b;     
  b = a;                   
  c = a === b;             
  ```


## Identity not equals

Use the `identity not equals operator '!=='` to COMPARE two values where a resultant `boolean` type value is `true` if the two values are NOT equal and `false` otherwise. A reference type value is not equal to another reference type value if both values refer to different instances on the heap or if one value is `null` and the other is not. A valid comparison is between `boolean` type values, numeric type values, or reference type values.
**Errors**
- If a comparison is made between a `boolean` type value and numeric type value.
- If a comparison is made between a primitive type value and a reference type value.

**Grammar**
```text
identity_not_equals: expression '!==' expression;
```

**Promotion**

|           |         |        |        |        |        |        |        |        |           |     |
|-----------|---------|--------|--------|--------|--------|--------|--------|--------|-----------|-----|
|           | boolean | byte   | short  | char   | int    | long   | float  | double | Reference | def |
| boolean   | boolean | -      | -      | -      | -      | -      | -      | -      | -         | def |
| byte      | -       | int    | int    | int    | int    | long   | float  | double | -         | def |
| short     | -       | int    | int    | int    | int    | long   | float  | double | -         | def |
| char      | -       | int    | int    | int    | int    | long   | float  | double | -         | def |
| int       | -       | int    | int    | int    | int    | long   | float  | double | -         | def |
| long      | -       | long   | long   | long   | long   | long   | float  | double | -         | def |
| float     | -       | float  | float  | float  | float  | float  | float  | double | -         | def |
| double    | -       | double | double | double | double | double | double | double | -         | def |
| Reference | -       | -      | -      | -      | -      | -      | -      | -      | Object    | def |
| def       | def     | def    | def    | def    | def    | def    | def    | def    | def       | def |

**Examples**
- Identity not equals with reference type values
  ```java
  List a = new ArrayList(); 
  List b = new ArrayList(); 
  List c = a;               
  boolean c = a !== b;      
  c = a !== c;              
  ```
- Identity not equals with `null`
  ```java
  Object a = null;        
  Object b = null;        
  boolean c = a !== null; 
  c = a !== b;            
  b = new Object();       
  c = a !== b;            
  ```
- Identity not equals with the `def` type
  ```java
  def a = new HashMap();   
  def b = new ArrayList(); 
  boolean c = a !== b;     
  b = a;                   
  c = a !== b;             
  ```


## Boolean xor

Use the `boolean xor operator '^'` to XOR together two `boolean` type values where if one `boolean` type value is `true` and the other is `false` the resultant `boolean` type value is `true` and `false` otherwise.
**Errors**
- If either evaluated value is a value other than a `boolean` type value or a value that is castable to a `boolean` type value.

**Truth**

|       |       |       |
|-------|-------|-------|
|       | true  | false |
| true  | false | true  |
| false | true  | false |

**Grammar**
```text
boolean_xor: expression '^' expression;
```

**Examples**
- Boolean xor with the `boolean` type
  ```java
  boolean x = false;    
  boolean y = x ^ true; 
  y = y ^ x;            
  ```
- Boolean xor with the `def` type
  ```java
  def x = false;    
  def y = x ^ true; 
  y = y ^ x;        
  ```


## Boolean and

Use the `boolean and operator '&&'` to AND together two `boolean` type values where if both `boolean` type values are `true` the resultant `boolean` type value is `true` and `false` otherwise.
**Errors**
- If either evaluated value is a value other than a `boolean` type value or a value that is castable to a `boolean` type value.

**Truth**

|       |       |       |
|-------|-------|-------|
|       | true  | false |
| true  | true  | false |
| false | false | false |

**Grammar**
```text
boolean_and: expression '&&' expression;
```

**Examples**
- Boolean and with the `boolean` type
  ```java
  boolean x = true;      
  boolean y = x && true; 
  x = false;             
  y = y && x;            
  ```
- Boolean and with the `def` type
  ```java
  def x = true;      
  def y = x && true; 
  x = false;         
  y = y && x;        
  ```


## Boolean or

Use the `boolean or operator '||'` to OR together two `boolean` type values where if either one of the `boolean` type values is `true` the resultant `boolean` type value is `true` and `false` otherwise.
**Errors**
- If either evaluated value is a value other than a `boolean` type value or a value that is castable to a `boolean` type value.

**Truth**

|       |      |       |
|-------|------|-------|
|       | true | false |
| true  | true | true  |
| false | true | false |

**Grammar:**
```text
boolean_and: expression '||' expression;
```

**Examples**
- Boolean or with the `boolean` type
  ```java
  boolean x = false;     
  boolean y = x || true; 
  y = false;             
  y = y || x;            
  ```
- Boolean or with the `def` type
  ```java
  def x = false;     
  def y = x || true; 
  y = false;         
  y = y || x;        
  ```