﻿---
title: Operators: Array
description: Use the array initialization operator '[] {}' to allocate a single-dimensional array type instance to the heap with a set of pre-defined elements. Each...
url: https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-array
products:
  - Elasticsearch
  - Painless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Operators: Array
## Array initialization

Use the `array initialization operator '[] {}'` to allocate a single-dimensional [array type](/docs/reference/scripting-languages/painless/painless-types#array-type) instance to the heap with a set of pre-defined elements. Each value used to initialize an element in the array type instance is cast to the specified element type value upon insertion. The order of specified values is maintained.
For help with any required debugging, refer to [Debug array manipulation errors in Painless](https://www.elastic.co/docs/explore-analyze/scripting/painless-array-list-manipulation-errors).
**Errors**
- If a value is not castable to the specified type value.

**Grammar**
```text
array_initialization: 'new' TYPE '[' ']' '{' expression_list '}'
                    | 'new' TYPE '[' ']' '{' '}';
expression_list: expression (',' expression);
```

**Example:**
- Array initialization with static values
  ```java
  int[] x = new int[] {1, 2, 3}; 
  ```
- Array initialization with non-static values.
  ```java
  int i = 1;      
  long l = 2L;    
  float f = 3.0F; 
  double d = 4.0; 
  String s = "5"; 
  def array = new def[] {i, l, f*d, s}; 
  ```


## Array access

Use the `array access operator '[]'` to store a value to or load a value from an [array type](/docs/reference/scripting-languages/painless/painless-types#array-type) value. Each element of an array type value is accessed with an `int` type value to specify the index to store/load. The range of elements within an array that are accessible is `[0, size)` where size is the number of elements specified at the time of allocation. Use a negative `int` type value as an index to access an element in reverse from the end of an array type value within a range of `[-size, -1]`.
**Errors**
- If a value other than an `int` type value or a value that is castable to an `int` type value is provided as an index.
- If an element is accessed outside of the valid ranges.

**Grammar**
```text
brace_access: '[' expression ']'
```

**Examples**
- Array access with a single-dimensional array
  ```java
  int[] x = new int[2]; 
  x[0] = 2;             
  x[1] = 5;             
  int y = x[0] + x[1];  
  int z = 1;            
  int i = x[z];         
  ```
- Array access with the `def` type
  ```java
  def d = new int[2];  
  d[0] = 2;            
  d[1] = 5;            
  def x = d[0] + d[1]; 
  def y = 1;           
  def z = d[y];        
  ```
- Array access with a multi-dimensional array
  ```java
  int[][][] ia3 = new int[2][3][4]; 
  ia3[1][2][3] = 99;                
  int i = ia3[1][2][3];             
  ```


## Array length

An array type value contains a read-only member field named `length`. The `length` field stores the size of the array as an `int` type value where size is the number of elements specified at the time of allocation. Use the [field access operator](/docs/reference/scripting-languages/painless/painless-operators-reference#field-access-operator) to load the field `length` from an array type value.
**Examples**
- Access the `length` field
  ```java
  int[] x = new int[10]; 
  int l = x.length;      
  ```


## New array

Use the `new array operator 'new []'` to allocate an array type instance to the heap. Specify the element type following the `new` token. Specify each dimension with the `[` and `]` tokens following the element type name. The size of each dimension is specified by an `int` type value in between each set of `[` and `]` tokens.
**Errors**
- If a value other than an `int` type value or a value that is castable to an `int` type value is specified for a dimension’s size.

**Grammar**
```text
new_array: 'new' TYPE ('[' expression ']')+;
```

**Examples**
- Allocation of different array types
  ```java
  int[] x = new int[5];    
  x = new int[10];         
  int y = 2;               
  def z = new def[y][y*2]; 
  ```