﻿---
title: Keywords (reserved terms)
description: Keywords are reserved tokens for built-in language features in Painless. These special words have predefined meanings and cannot be used as identifiers,...
url: https://www.elastic.co/docs/reference/scripting-languages/painless/painless-keywords
products:
  - Elasticsearch
  - Painless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Keywords (reserved terms)
Keywords are reserved tokens for built-in language features in Painless. These special words have predefined meanings and cannot be used as [identifiers](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-identifiers), such as variable names, function names, or field names.
<important>
  In Painless documentation, "keywords" refers to reserved words in the scripting language itself. They are different from the Elasticsearch [`keyword`](/docs/reference/elasticsearch/mapping-reference/keyword#keyword-field-type) field type, which is used for exact-value searches and aggregations in your data mappings.
</important>

When you write Painless scripts, keywords provide the fundamental building blocks for creating logic, defining data types, and controlling program flow. Since these words have special significance to the Painless compiler, attempting to use them for other purposes results in compilation errors.

### List of keywords:


| if  | else     | while | do     | for        |
|-----|----------|-------|--------|------------|
| in  | continue | break | return | new        |
| try | catch    | throw | this   | instanceof |


## Understanding keyword restrictions

Examples of restricted terms include `if`, which tells the compiler to create a conditional statement, and `int`, which declares an integer variable type.

### Examples of valid keyword usage:

```
// Keywords used correctly for their intended purpose
int count = 0;          
boolean isActive = true;
if (count > 0) {        
    return count;       
}
```


### Errors

If a keyword is used as an identifier Painless generates a compilation error:
```
// These will cause compilation errors
int if = 10;            
String return = "value";
boolean int = false;    

// Use descriptive names instead
int count = 10;
String result = "value";
boolean isEnabled = false;
```

These restrictions ensure that your scripts remain readable and that the Painless compiler can correctly parse your code without ambiguity.