﻿---
title: Identifiers
description: Use an identifier as a named token to specify a variable, type, field, method, or function. Identifiers are the names you give to elements in your code...
url: https://www.elastic.co/docs/reference/scripting-languages/painless/painless-identifiers
products:
  - Elasticsearch
  - Painless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Identifiers
Use an identifier as a named token to specify a [variable](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-variables), [type](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-types), [field](/docs/reference/scripting-languages/painless/painless-operators-reference#field-access-operator), [method](/docs/reference/scripting-languages/painless/painless-operators-reference#method-call-operator), or [function](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-functions).
<important>
  Identifiers cannot be [keywords](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-keywords). Using a keyword as an identifier will result in a compilation error.
</important>

Identifiers are the names you give to elements in your code. They must follow specific naming rules and provide meaningful names that clearly describe their purpose.

## Grammar

```java
ID: [_a-zA-Z] [_a-zA-Z-0-9]*;
```


## Naming rules

- Must start with a letter (a-z, A-Z) or underscore (_)
- Can contain letters, numbers (0-9), and underscores
- Case sensitive (`myVar` and `MyVar` are different)
- Cannot be a [keyword](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-keywords)


### Examples

- Variations of identifiers
  ```text
   a      
   Z      
   id     
   list   
   list0  
   MAP25  
   _map25 
   Map_25 
  ```


## Best practices

Choose meaningful identifier names that clearly describe their purpose:
```
// Good: descriptive and clear
String customerEmail = "user@example.com";
int totalPrice = calculateTotal();
boolean isProductAvailable = checkInventory();

// Avoid: unclear or too short
String s = "user@example.com";
int x = calculateTotal();
boolean b = checkInventory();
```