﻿---
title: Filter context
description: Use a Painless script as a filter in a query to include and exclude documents. The standard Painless API is available. To run the example, first install...
url: https://www.elastic.co/docs/reference/scripting-languages/painless/painless-filter-context
products:
  - Elasticsearch
  - Painless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Filter context
Use a Painless script as a [filter](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-script-query) in a query to include and exclude documents.

## Variables

<definitions>
  <definition term="params (Map, read-only)">
    User-defined parameters passed in as part of the query.
  </definition>
  <definition term="doc (Map, read-only)">
    Contains the fields of the current document where each field is a `List` of values.
  </definition>
</definitions>


## Return

<definitions>
  <definition term="boolean">
    Return `true` if the current document should be returned as a result of the query, and `false` otherwise.
  </definition>
</definitions>


## API

The standard [Painless API](https://www.elastic.co/guide/en/elasticsearch/painless/current/painless-api-reference-shared.html) is available.

## Example

To run the example, first [install the eCommerce sample data](/docs/reference/scripting-languages/painless/painless-context-examples#painless-sample-data-install).
This example filters documents where the average price per item in an order exceeds a minimum threshold of 30.
<tip>
  Filters answer the question “Does this document match?” with a simple “Yes or No” response. Use filter context for all conditions that don’t need scoring. Refer to [Query and filter context](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-filter-context) to learn more.
</tip>

```json
GET kibana_sample_data_ecommerce/_search
{
  "query": {
    "bool": {
      "filter": {
        "script": {
          "script": {
            "source": """
                (doc['taxful_total_price'].value / doc['total_quantity'].value) > params.min_avg_price
            """,
            "params": {
              "min_avg_price": 30
            }
          }
        }
      }
    }
  }
}
```