﻿---
title: Datetime representation
description: Datetimes in Painless are most commonly represented as a numeric value, a string value, or a complex value. Switching between different representations...
url: https://www.elastic.co/docs/reference/scripting-languages/painless/painless-datetime-representation
products:
  - Elasticsearch
  - Painless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Datetime representation
Datetimes in Painless are most commonly represented as a numeric value, a string value, or a complex value.
<definitions>
  <definition term="numeric">
    A datetime representation as a number from a starting offset called an epoch; in Painless this is typically a [long](/docs/reference/scripting-languages/painless/painless-types#primitive-types) as milliseconds since an epoch of `1970-01-01 00:00:00` Zulu Time.
  </definition>
  <definition term="string">
    A datetime representation as a sequence of characters defined by a standard format or a custom format; in Painless this is typically a [String](/docs/reference/scripting-languages/painless/painless-types#string-type) of the standard format [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601).
  </definition>
  <definition term="complex">
    A datetime representation as a complex type ([object](/docs/reference/scripting-languages/painless/painless-types#reference-types)) that abstracts away internal details of how the datetime is stored and often provides utilities for modification and comparison; in Painless this is typically a [ZonedDateTime](https://www.elastic.co/guide/en/elasticsearch/painless/current/painless-api-reference-shared-java-time.html#painless-api-reference-shared-ZonedDateTime).
  </definition>
</definitions>

Switching between different representations of datetimes is often necessary to achieve a script’s objectives. A typical pattern in a script is to switch a numeric or string datetime to a complex datetime, modify or compare the complex datetime, and then switch it back to a numeric or string datetime for storage or to return a result.