﻿---
title: Datetime Modification
description: Use either a numeric datetime or a complex datetime to do modifications such as adding several seconds to a datetime or subtracting several days from...
url: https://www.elastic.co/docs/reference/scripting-languages/painless/painless-datetime-modification
products:
  - Elasticsearch
  - Painless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Datetime Modification
Use either a numeric datetime or a complex datetime to do modifications such as adding several seconds to a datetime or subtracting several days from a datetime. Use standard [numeric operators](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-operators-numeric) to modify a numeric datetime. Use [methods](https://www.elastic.co/guide/en/elasticsearch/painless/current/painless-api-reference-shared-java-time.html#painless-api-reference-shared-ZonedDateTime) (or fields) to modify a complex datetime. Many complex datetimes are immutable, so upon modification a new complex datetime is created that requires [assignment](/docs/reference/scripting-languages/painless/painless-variables#variable-assignment) or immediate use.

## Datetime modification examples

- Subtract three seconds from a numeric datetime in milliseconds:
  ```java
  long milliSinceEpoch = 434931330000L;
  milliSinceEpoch = milliSinceEpoch - 1000L*3L;
  ```
- Add three days to a complex datetime:
  ```java
  ZonedDateTime zdt =
          ZonedDateTime.of(1983, 10, 13, 22, 15, 30, 0, ZoneId.of('Z'));
  ZonedDateTime updatedZdt = zdt.plusDays(3);
  ```
- Subtract 125 minutes from a complex datetime:
  ```java
  ZonedDateTime zdt =
          ZonedDateTime.of(1983, 10, 13, 22, 15, 30, 0, ZoneId.of('Z'));
  ZonedDateTime updatedZdt = zdt.minusMinutes(125);
  ```
- Set the year on a complex datetime:
  ```java
  ZonedDateTime zdt =
          ZonedDateTime.of(1983, 10, 13, 22, 15, 30, 0, ZoneId.of('Z'));
  ZonedDateTime updatedZdt = zdt.withYear(1976);
  ```