﻿---
title: Datetime conversion
description: Datetime conversion is a switch from a numeric datetime to a complex datetime and the reverse. Convert a date from milliseconds:, Convert a date to milliseconds:...
url: https://www.elastic.co/docs/reference/scripting-languages/painless/painless-datetime-conversion
products:
  - Elasticsearch
  - Painless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Datetime conversion
Datetime conversion is a switch from a numeric datetime to a complex datetime and the reverse.

## Datetime conversion examples

- Convert a date from milliseconds:
  ```java
  long milliSinceEpoch = 434931330000L;
  Instant instant = Instant.ofEpochMilli(milliSinceEpoch);
  ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, ZoneId.of('Z'));
  ```
- Convert a date to milliseconds:
  ```java
  ZonedDateTime zdt =
          ZonedDateTime.of(1983, 10, 13, 22, 15, 30, 0, ZoneId.of('Z'));
  long milliSinceEpoch = zdt.toInstant().toEpochMilli();
  ```