﻿---
title: Painless contexts
description: In Painless, a context defines where and how your script runs in Elasticsearch. Each context determines three key aspects: which parameters are available...
url: https://www.elastic.co/docs/reference/scripting-languages/painless/painless-contexts
products:
  - Elasticsearch
  - Painless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Painless contexts
In Painless, a context defines where and how your script runs in Elasticsearch. Each context determines three key aspects: which parameters are available to your script (such as `doc`, `ctx`, or `_source`), which Java classes and methods your script can access, and what type of value your script should return.

## What are contexts?

Contexts are runtime environments that determine script behavior within specific Elasticsearch operations. Unlike traditional scripting languages, where code runs consistently everywhere, Painless scripts are context-aware: the same syntax can access different variables and produce different results depending on the Elasticsearch operation that calls it.

## How contexts work

Painless supports scripting across numerous Elasticsearch operations, from search scoring to document processing to aggregation calculations. Each operation requires different capabilities; search scripts need read-only field access, while ingest scripts need document modification abilities. This diversity of requirements creates the need for specialized contexts.
Contexts ensure appropriate access and capabilities for each Elasticsearch operation while maintaining security and performance by providing exactly the inputs and APIs needed for a specific task through fine-grained allowlists and optimized data access patterns.
For example, search scoring contexts provide document fields as input and generate numerical scores as output, while ingest contexts provide documents as input for modification and generate transformed documents as output. Even if some contexts appear to be similar, each has tools and restrictions designed for a specific purpose.

## Context and data access

Contexts determine how you can access document data in Painless scripts:
<note>
  The parameters listed here might not be available in all contexts. Some or even none might be available depending on the context that the script is written for.
</note>

<definitions>
  <definition term="doc values:">
    Read-only field access using columnar storage for search, aggregation, and sorting context
  </definition>
  <definition term="ctx access:">
    Document modification capabilities in update, ingest, and reindex context
  </definition>
  <definition term="_source access:">
    Complete document JSON for runtime fields and transformations
  </definition>
  <definition term="params">
    User-defined parameters passed into scripts, available across all contexts
  </definition>
</definitions>

For detailed data access patterns and examples, refer to [Painless syntax-context bridge](https://www.elastic.co/docs/explore-analyze/scripting/painless-syntax-context-bridge).

## Context Categories overview

While Painless supports more than twenty specific contexts, they operate within four categories.
<definitions>
  <definition term="Document Processing">
    Transform and extract data from existing documents without modifying the original content. Use runtime fields, ingest processors, and field scripts to create computed fields or parse log data.
  </definition>
  <definition term="Document Modification">
    Change or update document context permanently in the index. Use update scripts, update by query, and reindex scripts to modify fields or restructure documents.
  </definition>
  <definition term="Search Enhancement">
    Customize search behavior, scoring, or sorting without changing the indexed documents. Use filter scripts, and sort scripts for custom relevance or dynamic filtering.
  </definition>
  <definition term="Advanced Operations">
    Implement specialized functionality such as custom aggregations or monitoring conditions. Use metric aggregation, bucket aggregation, and Watcher scripts for complex calculations and alerting.
  </definition>
</definitions>


## Painless context reference


| Name                              | Painless documentation                                                                                                            | Elasticsearch documentation                                                                                                                |
|-----------------------------------|-----------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------|
| Runtime field                     | [Painless documentation](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-runtime-fields-context)      | [Elasticsearch documentation](https://www.elastic.co/docs/manage-data/data-store/mapping/runtime-fields)                                   |
| Field                             | [Painless documentation](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-field-context)               | [Elasticsearch documentation](/docs/reference/elasticsearch/rest-apis/retrieve-selected-fields#script-fields)                              |
| Ingest processor                  | [Painless documentation](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-ingest-processor-context)    | [Elasticsearch documentation](https://www.elastic.co/docs/reference/enrich-processor/script-processor)                                     |
| Filter                            | [Painless documentation](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-filter-context)              | [Elasticsearch documentation](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-script-query)                      |
| Score                             | [Painless documentation](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-score-context)               | [Elasticsearch documentation](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-function-score-query)              |
| Sort                              | [Painless documentation](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-sort-context)                | [Elasticsearch documentation](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/sort-search-results)                           |
| Update                            | [Painless documentation](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-update-context)              | [Elasticsearch documentation](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-update)                                |
| Update by query                   | [Painless documentation](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-update-by-query-context)     | [Elasticsearch documentation](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-update-by-query)                       |
| Reindex                           | [Painless documentation](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-reindex-context)             | [Elasticsearch documentation](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-reindex)                               |
| Similarity                        | [Painless documentation](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-similarity-context)          | [Elasticsearch documentation](https://www.elastic.co/docs/reference/elasticsearch/index-settings/similarity)                               |
| Weight                            | [Painless documentation](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-weight-context)              | [Elasticsearch documentation](https://www.elastic.co/docs/reference/elasticsearch/index-settings/similarity)                               |
| Minimum should match              | [Painless documentation](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-min-should-match-context)    | [Elasticsearch documentation](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-terms-set-query)                   |
| Metric aggregation initialization | [Painless documentation](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-metric-agg-init-context)     | [Elasticsearch documentation](https://www.elastic.co/docs/reference/aggregations/search-aggregations-metrics-scripted-metric-aggregation)  |
| Metric aggregation map            | [Painless documentation](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-metric-agg-map-context)      | [Elasticsearch documentation](https://www.elastic.co/docs/reference/aggregations/search-aggregations-metrics-scripted-metric-aggregation)  |
| Metric aggregation combine        | [Painless documentation](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-metric-agg-combine-context)  | [Elasticsearch documentation](https://www.elastic.co/docs/reference/aggregations/search-aggregations-metrics-scripted-metric-aggregation)  |
| Metric aggregation reduce         | [Painless documentation](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-metric-agg-reduce-context)   | [Elasticsearch documentation](https://www.elastic.co/docs/reference/aggregations/search-aggregations-metrics-scripted-metric-aggregation)  |
| Bucket script aggregation         | [Painless documentation](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-bucket-script-agg-context)   | [Elasticsearch documentation](https://www.elastic.co/docs/reference/aggregations/search-aggregations-pipeline-bucket-script-aggregation)   |
| Bucket selector aggregation       | [Painless documentation](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-bucket-selector-agg-context) | [Elasticsearch documentation](https://www.elastic.co/docs/reference/aggregations/search-aggregations-pipeline-bucket-selector-aggregation) |
| Watcher condition                 | [Painless documentation](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-watcher-condition-context)   | [Elasticsearch documentation](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/condition-script)                           |
| Watcher transform                 | [Painless documentation](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-watcher-transform-context)   | [Elasticsearch documentation](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/transform-script)                           |


## Next steps

- **Most common context:** Start with [Field context](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-field-context) or [Runtime field context](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-runtime-fields-context) for data extraction and transformation.
- **Data access patterns:** Review Painless syntax-context bridge for `doc`, `ctx`, and `_source` usage examples.
- **Step-by-step tutorials**: refer to [How to write Painless scripts](https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-using) and our [Painless tutorials](https://www.elastic.co/docs/explore-analyze/scripting/common-script-uses) in the Explore and Analyze section.

Before using a Painless context, [configure the example data](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-context-examples). Each context example is configured to operate on this data.