﻿---
title: SQL Translate API
description: The SQL Translate API accepts SQL in a JSON document and translates it into native Elasticsearch queries. For example: Which returns: Which is the request...
url: https://www.elastic.co/docs/reference/query-languages/sql/sql-translate
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# SQL Translate API
The SQL Translate API accepts SQL in a JSON document and translates it into native Elasticsearch queries. For example:
```json

{
  "query": "SELECT * FROM library ORDER BY page_count DESC",
  "fetch_size": 10
}
```

Which returns:
```json
{
  "size": 10,
  "_source": false,
  "fields": [
    {
      "field": "author"
    },
    {
      "field": "name"
    },
    {
      "field": "page_count"
    },
    {
      "field": "release_date",
      "format": "strict_date_optional_time_nanos"
    }
  ],
  "sort": [
    {
      "page_count": {
        "order": "desc",
        "missing": "_first",
        "unmapped_type": "short"
      }
    }
  ],
  "track_total_hits": -1
}
```

Which is the request that SQL will run to provide the results. In this case, SQL will use the [scroll](/docs/reference/elasticsearch/rest-apis/paginate-search-results#scroll-search-results) API. If the result contained an aggregation then SQL would use the normal [search API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search).
The request body accepts the same [parameters](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-sql-query) as the [SQL search API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-sql-query), excluding `cursor`.