﻿---
title: SHOW TABLES
description: See index patterns for more information about patterns. Description: List the tables available to the current user and their type. Match multiple indices...
url: https://www.elastic.co/docs/reference/query-languages/sql/sql-syntax-show-tables
products:
  - Elasticsearch
---

# SHOW TABLES
```sql
SHOW TABLES
    [CATALOG [catalog_identifier | 
              LIKE pattern]]?      
    [INCLUDE FROZEN]?              
    [table_identifier |            
     LIKE pattern]?                
```

See [index patterns](https://www.elastic.co/docs/reference/query-languages/sql/sql-index-patterns) for more information about patterns.
**Description**: List the tables available to the current user and their type.
```sql
SHOW TABLES;

 catalog       |     name      | type     |     kind
---------------+---------------+----------+---------------
javaRestTest      |emp            |TABLE     |INDEX
javaRestTest      |employees      |VIEW      |ALIAS
javaRestTest      |library        |TABLE     |INDEX
```

Match multiple indices by using Elasticsearch [multi-target syntax](/docs/reference/elasticsearch/rest-apis/api-conventions#api-multi-index) notation:
```sql
SHOW TABLES "*,-l*";

 catalog       |     name      | type     |     kind
---------------+---------------+----------+---------------
javaRestTest      |emp            |TABLE     |INDEX
javaRestTest      |employees      |VIEW      |ALIAS
```

One can also use the `LIKE` clause to restrict the list of names to the given pattern.
The pattern can be an exact match:
```sql
SHOW TABLES LIKE 'emp';

 catalog       |     name      | type     |     kind
---------------+---------------+----------+---------------
javaRestTest      |emp            |TABLE     |INDEX
```

Multiple chars:
```sql
SHOW TABLES LIKE 'emp%';

 catalog       |     name      | type     |     kind
---------------+---------------+----------+---------------
javaRestTest      |emp            |TABLE     |INDEX
javaRestTest      |employees      |VIEW      |ALIAS
```

A single char:
```sql
SHOW TABLES LIKE 'em_';

 catalog       |     name      | type     |     kind
---------------+---------------+----------+---------------
javaRestTest      |emp            |TABLE     |INDEX
```

Or a mixture of single and multiple chars:
```sql
SHOW TABLES LIKE '%em_';

 catalog       |     name      | type     |     kind
---------------+---------------+----------+---------------
javaRestTest      |emp            |TABLE     |INDEX
```

List tables within remote clusters whose names are matched by a wildcard:
```sql
SHOW TABLES CATALOG 'my_*' LIKE 'test_emp%';

     catalog     |     name      |     type      |     kind
-----------------+---------------+---------------+---------------
my_remote_cluster|test_emp       |TABLE          |INDEX
my_remote_cluster|test_emp_copy  |TABLE          |INDEX
```