﻿---
title: SHOW COLUMNS
description: See index patterns for more information about patterns. Description: List the columns in table and their data type (and other attributes). 
url: https://www.elastic.co/docs/reference/query-languages/sql/sql-syntax-show-columns
products:
  - Elasticsearch
---

# SHOW COLUMNS
```sql
SHOW COLUMNS
    [CATALOG identifier]? 
    [INCLUDE FROZEN]?     
    [FROM | IN]
    [table_identifier |   
     LIKE pattern]        
```

See [index patterns](https://www.elastic.co/docs/reference/query-languages/sql/sql-index-patterns) for more information about patterns.
**Description**: List the columns in table and their data type (and other attributes).
```sql
SHOW COLUMNS IN emp;

       column       |     type      |    mapping
--------------------+---------------+---------------
birth_date          |TIMESTAMP      |datetime
dep                 |STRUCT         |nested
dep.dep_id          |VARCHAR        |keyword
dep.dep_name        |VARCHAR        |text
dep.dep_name.keyword|VARCHAR        |keyword
dep.from_date       |TIMESTAMP      |datetime
dep.to_date         |TIMESTAMP      |datetime
emp_no              |INTEGER        |integer
first_name          |VARCHAR        |text
first_name.keyword  |VARCHAR        |keyword
gender              |VARCHAR        |keyword
hire_date           |TIMESTAMP      |datetime
languages           |TINYINT        |byte
last_name           |VARCHAR        |text
last_name.keyword   |VARCHAR        |keyword
name                |VARCHAR        |keyword
salary              |INTEGER        |integer
```