﻿---
title: Reserved keywords
description: Table with reserved keywords that need to be quoted. Also provide an example to make it more obvious. The following table lists all of the keywords that...
url: https://www.elastic.co/docs/reference/query-languages/sql/sql-syntax-reserved
products:
  - Elasticsearch
---

# Reserved keywords
Table with reserved keywords that need to be quoted. Also provide an example to make it more obvious.
The following table lists all of the keywords that are reserved in Elasticsearch SQL, along with their status in the SQL standard. These reserved keywords must be quoted (using double quotes) in order to be used as an identifier, for example:
```sql
SELECT "AS" FROM index
```


| **Keyword**         | **SQL:2016** | **SQL-92** |
|---------------------|--------------|------------|
| `ALL`               | reserved     | reserved   |
| `AND`               | reserved     | reserved   |
| `ANY`               | reserved     | reserved   |
| `AS`                | reserved     | reserved   |
| `ASC`               | reserved     | reserved   |
| `BETWEEN`           | reserved     | reserved   |
| `BY`                | reserved     | reserved   |
| `CAST`              | reserved     | reserved   |
| `CATALOG`           | reserved     | reserved   |
| `CONVERT`           | reserved     | reserved   |
| `CURRENT_DATE`      | reserved     | reserved   |
| `CURRENT_TIMESTAMP` | reserved     | reserved   |
| `CURRENT_TIME`      | reserved     | reserved   |
| `DAY`               | reserved     | reserved   |
| `DAYS`              |              |            |
| `DESC`              | reserved     | reserved   |
| `DESCRIBE`          | reserved     | reserved   |
| `DISTINCT`          | reserved     | reserved   |
| `ESCAPE`            | reserved     | reserved   |
| `EXISTS`            | reserved     | reserved   |
| `EXPLAIN`           | reserved     | reserved   |
| `EXTRACT`           | reserved     | reserved   |
| `FALSE`             | reserved     | reserved   |
| `FIRST`             | reserved     | reserved   |
| `FROM`              | reserved     | reserved   |
| `FULL`              | reserved     | reserved   |
| `GROUP`             | reserved     | reserved   |
| `HAVING`            | reserved     | reserved   |
| `HOUR`              | reserved     | reserved   |
| `HOURS`             |              |            |
| `IN`                | reserved     | reserved   |
| `INNER`             | reserved     | reserved   |
| `INTERVAL`          | reserved     | reserved   |
| `IS`                | reserved     | reserved   |
| `JOIN`              | reserved     | reserved   |
| `LEFT`              | reserved     | reserved   |
| `LIKE`              | reserved     | reserved   |
| `LIMIT`             | reserved     | reserved   |
| `MATCH`             | reserved     | reserved   |
| `MINUTE`            | reserved     | reserved   |
| `MINUTES`           |              |            |
| `MONTH`             | reserved     | reserved   |
| `NATURAL`           | reserved     | reserved   |
| `NOT`               | reserved     | reserved   |
| `NULL`              | reserved     | reserved   |
| `NULLS`             |              |            |
| `ON`                | reserved     | reserved   |
| `OR`                | reserved     | reserved   |
| `ORDER`             | reserved     | reserved   |
| `OUTER`             | reserved     | reserved   |
| `RIGHT`             | reserved     | reserved   |
| `RLIKE`             |              |            |
| `QUERY`             |              |            |
| `SECOND`            | reserved     | reserved   |
| `SECONDS`           |              |            |
| `SELECT`            | reserved     | reserved   |
| `SESSION`           |              | reserved   |
| `TABLE`             | reserved     | reserved   |
| `TABLES`            |              |            |
| `THEN`              | reserved     | reserved   |
| `TO`                | reserved     | reserved   |
| `TOP`               | reserved     | reserved   |
| `TRUE`              | reserved     | reserved   |
| `TYPE`              |              |            |
| `USING`             | reserved     | reserved   |
| `WHEN`              | reserved     | reserved   |
| `WHERE`             | reserved     | reserved   |
| `WITH`              | reserved     | reserved   |
| `YEAR`              | reserved     | reserved   |
| `YEARS`             |              |            |