﻿---
title: DESCRIBE TABLE
description: Description: DESC and DESCRIBE are aliases to SHOW COLUMNS. 
url: https://www.elastic.co/docs/reference/query-languages/sql/sql-syntax-describe-table
products:
  - Elasticsearch
---

# DESCRIBE TABLE
```sql
DESCRIBE | DESC
    [CATALOG identifier]? 
    [INCLUDE FROZEN]?     
    [table_identifier |   
     LIKE pattern]        
```

**Description**: `DESC` and `DESCRIBE` are aliases to [SHOW COLUMNS](https://www.elastic.co/docs/reference/query-languages/sql/sql-syntax-show-columns).
```sql
DESCRIBE emp;

       column       |     type      |    mapping
--------------------+---------------+---------------
birth_date          |TIMESTAMP      |datetime
dep                 |STRUCT         |nested
dep.dep_id          |VARCHAR        |keyword
dep.dep_name        |VARCHAR        |text
dep.dep_name.keyword|VARCHAR        |keyword
dep.from_date       |TIMESTAMP      |datetime
dep.to_date         |TIMESTAMP      |datetime
emp_no              |INTEGER        |integer
first_name          |VARCHAR        |text
first_name.keyword  |VARCHAR        |keyword
gender              |VARCHAR        |keyword
hire_date           |TIMESTAMP      |datetime
languages           |TINYINT        |byte
last_name           |VARCHAR        |text
last_name.keyword   |VARCHAR        |keyword
name                |VARCHAR        |keyword
salary              |INTEGER        |integer
```