﻿---
title: Use runtime fields
description: Use the runtime_mappings parameter to extract and create runtime fields, or columns, from existing ones during a search. The following search creates...
url: https://www.elastic.co/docs/reference/query-languages/sql/sql-runtime-fields
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Use runtime fields
Use the `runtime_mappings` parameter to extract and create [runtime fields](https://www.elastic.co/docs/manage-data/data-store/mapping/runtime-fields), or columns, from existing ones during a search.
The following search creates a `release_day_of_week` runtime field from `release_date` and returns it in the response.
```json

{
  "runtime_mappings": {
    "release_day_of_week": {
      "type": "keyword",
      "script": """
        emit(doc['release_date'].value.dayOfWeekEnum.toString())
      """
    }
  },
  "query": """
    SELECT * FROM library WHERE page_count > 300 AND author = 'Frank Herbert'
  """
}
```

The API returns:
```txt
    author     |     name      |  page_count   |      release_date      |release_day_of_week
---------------+---------------+---------------+------------------------+-------------------
Frank Herbert  |Dune           |604            |1965-06-01T00:00:00.000Z|TUESDAY
```