﻿---
title: Passing parameters to a query
description: Using values in a query condition, for example, or in a HAVING statement can be done "inline", by integrating the value in the query string itself: or...
url: https://www.elastic.co/docs/reference/query-languages/sql/sql-rest-params
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Passing parameters to a query
Using values in a query condition, for example, or in a `HAVING` statement can be done "inline", by integrating the value in the query string itself:
```json

{
  "query": "SELECT YEAR(release_date) AS year FROM library WHERE page_count > 300 AND author = 'Frank Herbert' GROUP BY year HAVING COUNT(*) > 0"
}
```

or it can be done by extracting the values in a separate list of parameters and using question mark placeholders (`?`) in the query string:
```json

{
  "query": "SELECT YEAR(release_date) AS year FROM library WHERE page_count > ? AND author = ? GROUP BY year HAVING COUNT(*) > ?",
  "params": [300, "Frank Herbert", 0]
}
```

<important>
  The recommended way of passing values to a query is with question mark placeholders, to avoid any attempts of hacking or SQL injection.
</important>