﻿---
title: Filtering using Elasticsearch Query DSL
description: You can filter the results that SQL will run on using a standard Elasticsearch Query DSL by specifying the query in the filter parameter. Which returns:...
url: https://www.elastic.co/docs/reference/query-languages/sql/sql-rest-filtering
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Filtering using Elasticsearch Query DSL
You can filter the results that SQL will run on using a standard Elasticsearch Query DSL by specifying the query in the filter parameter.
```json

{
  "query": "SELECT * FROM library ORDER BY page_count DESC",
  "filter": {
    "range": {
      "page_count": {
        "gte" : 100,
        "lte" : 200
      }
    }
  },
  "fetch_size": 5
}
```

Which returns:
```text
    author     |                name                |  page_count   | release_date
---------------+------------------------------------+---------------+------------------------
Douglas Adams  |The Hitchhiker's Guide to the Galaxy|180            |1979-10-12T00:00:00.000Z
```

<tip>
  A useful and less obvious usage for standard Query DSL filtering is to search documents by a specific [routing key](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/search-shard-routing#search-routing). Because Elasticsearch SQL does not support a `routing` parameter, one can specify a [`terms` filter for the `_routing` field](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-routing-field) instead:
  ```json

  {
    "query": "SELECT * FROM library",
    "filter": {
      "terms": {
        "_routing": ["abc"]
      }
    }
  }
  ```
</tip>