﻿---
title: Comparison operators
description: Boolean operator for comparing against one or multiple expressions. 
url: https://www.elastic.co/docs/reference/query-languages/sql/sql-operators
products:
  - Elasticsearch
---

# Comparison operators
Boolean operator for comparing against one or multiple expressions.

## `Equality (=)`

```sql
SELECT last_name l FROM "test_emp" WHERE emp_no = 10000 LIMIT 5;
```


## `Null safe Equality (<=>)`

```sql
SELECT 'elastic' <=> null AS "equals";

    equals
---------------
false
```

```sql
SELECT null <=> null AS "equals";

    equals
---------------
true
```


## `Inequality (<> or !=)`

```sql
SELECT last_name l FROM "test_emp" WHERE emp_no <> 10000 ORDER BY emp_no LIMIT 5;
```


## `Comparison (<, <=, >, >=)`

```sql
SELECT last_name l FROM "test_emp" WHERE emp_no < 10003 ORDER BY emp_no LIMIT 5;
```


## `BETWEEN`

```sql
SELECT last_name l FROM "test_emp" WHERE emp_no BETWEEN 9990 AND 10003 ORDER BY emp_no;
```


## `IS NULL/IS NOT NULL`

```sql
SELECT last_name l FROM "test_emp" WHERE emp_no IS NOT NULL AND gender IS NULL;
```


## `IN (<value1>, <value2>, ...)`

```sql
SELECT last_name l FROM "test_emp" WHERE emp_no IN (10000, 10001, 10002, 999) ORDER BY emp_no LIMIT 5;
```