﻿---
title: SQL JDBC
description: Elasticsearch's SQL jdbc driver is a rich, fully featured JDBC driver for Elasticsearch. It is Type 4 driver, meaning it is a platform independent, stand-alone,...
url: https://www.elastic.co/docs/reference/query-languages/sql/sql-jdbc
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# SQL JDBC
Elasticsearch's SQL jdbc driver is a rich, fully featured JDBC driver for Elasticsearch. It is Type 4 driver, meaning it is a platform independent, stand-alone, Direct to Database, pure Java driver that converts JDBC calls to Elasticsearch SQL.

## Installation

The JDBC driver can be obtained from:
<definitions>
  <definition term="Dedicated page">
    [elastic.co](https://www.elastic.co/downloads/jdbc-client) provides links, typically for manual downloads.
  </definition>
  <definition term="Maven dependency">
    [Maven](https://maven.apache.org/)-compatible tools can retrieve it automatically as a dependency:
  </definition>
</definitions>

```xml
<dependency>
  <groupId>org.elasticsearch.plugin</groupId>
  <artifactId>x-pack-sql-jdbc</artifactId>
  <version>9.3.0</version>
</dependency>
```

from [Maven Central Repository](https://search.maven.org/artifact/org.elasticsearch.plugin/x-pack-sql-jdbc), or from `artifacts.elastic.co/maven` by adding it to the repositories list:
```xml
<repositories>
  <repository>
    <id>elastic.co</id>
    <url>https://artifacts.elastic.co/maven</url>
  </repository>
</repositories>
```


## Version compatibility

Your driver must be compatible with your Elasticsearch version.
<important>
  The driver version cannot be newer than the Elasticsearch version. For example, Elasticsearch version 7.10.0 is not compatible with 9.3.0 drivers.
</important>


| Elasticsearch version      | Compatible driver versions | Example                                                    |
|----------------------------|----------------------------|------------------------------------------------------------|
| 7.7.0 and earlier versions | * The same version.        | Elasticsearch 7.6.1 is only compatible with 7.6.1 drivers. |


## Setup

The driver main class is `org.elasticsearch.xpack.sql.jdbc.EsDriver`. Note the driver implements the JDBC 4.0 `Service Provider` mechanism meaning it is registered automatically as long as it is available in the classpath.
Once registered, the driver understands the following syntax as an URL:
```text
jdbc:[es|elasticsearch]://[[http|https]://]?[host[:port]]?/[prefix]?[\?[option=value]&]*
```

<definitions>
  <definition term="jdbc:[es|elasticsearch]://">
    Prefix. Mandatory.
  </definition>
  <definition term="[[http|https]://]">
    Type of HTTP connection to make. Possible values are `http` (default) or `https`. Optional.
  </definition>
  <definition term="[host[:port]]">
    Host (`localhost` by default) and port (`9200` by default). Optional.
  </definition>
  <definition term="[prefix]">
    Prefix (empty by default). Typically used when hosting Elasticsearch under a certain path. Optional.
  </definition>
  <definition term="[option=value]">
    Properties for the JDBC driver. Empty by default. Optional.
  </definition>
</definitions>

The driver recognized the following properties:

#### Essential


<definitions>
  <definition term="timezone (default JVM timezone)">
    Timezone used by the driver *per connection* indicated by its `ID`. **Highly** recommended to set it (to, say, `UTC`) as the JVM timezone can vary, is global for the entire JVM and can’t be changed easily when running under a security manager.
  </definition>
</definitions>


#### Network

<definitions>
  <definition term="connect.timeout (default 30000)">
    Connection timeout (in milliseconds). That is the maximum amount of time waiting to make a connection to the server.
  </definition>
  <definition term="network.timeout (default 60000)">
    Network timeout (in milliseconds). That is the maximum amount of time waiting for the network.
  </definition>
  <definition term="page.size (default 1000)">
    Page size (in entries). The number of results returned per page by the server.
  </definition>
  <definition term="page.timeout (default 45000)">
    Page timeout (in milliseconds). Minimum retention period for the scroll cursor on the server. Queries that require a stateful scroll cursor on the server side might fail after this timeout. Hence, when scrolling through large result sets, processing `page.size` records should not take longer than `page.timeout` milliseconds.
  </definition>
  <definition term="query.timeout (default 90000)">
    Query timeout (in milliseconds). That is the maximum amount of time waiting for a query to return.
  </definition>
</definitions>


### Basic Authentication

<definitions>
  <definition term="user">
    Basic Authentication user name
  </definition>
  <definition term="password">
    Basic Authentication password
  </definition>
</definitions>


### SSL

<definitions>
  <definition term="ssl (default false)">
    Enable SSL
  </definition>
  <definition term="ssl.keystore.location">
    key store (if used) location
  </definition>
  <definition term="ssl.keystore.pass">
    key store password
  </definition>
  <definition term="ssl.keystore.type (default JKS)">
    key store type. `PKCS12` is a common, alternative format
  </definition>
  <definition term="ssl.truststore.location">
    trust store location
  </definition>
  <definition term="ssl.truststore.pass">
    trust store password
  </definition>
  <definition term="ssl.truststore.type (default JKS)">
    trust store type. `PKCS12` is a common, alternative format
  </definition>
  <definition term="ssl.protocol(default TLS)">
    SSL protocol to be used
  </definition>
</definitions>


### Proxy

<definitions>
  <definition term="proxy.http">
    Http proxy host name
  </definition>
  <definition term="proxy.socks">
    SOCKS proxy host name
  </definition>
</definitions>


### Mapping

<definitions>
  <definition term="field.multi.value.leniency (default true)">
    Whether to be lenient and return the first value (without any guarantees of what that will be - typically the first in natural ascending order) for fields with multiple values (true) or throw an exception.
  </definition>
</definitions>


### Index

<definitions>
  <definition term="index.include.frozen (default false)">
    Whether to include frozen indices in the query execution or not (default).
  </definition>
</definitions>


### Cluster

<definitions>
  <definition term="catalog">
    Default catalog (cluster) for queries. If unspecified, the queries execute on the data in the local cluster only.
    See [cross-cluster search](https://www.elastic.co/docs/explore-analyze/cross-cluster-search).
  </definition>
</definitions>


### Error handling

<definitions>
  <definition term="allow.partial.search.results (default false)">
    Whether to return partial results in case of shard failure or fail the query throwing the underlying exception (default).
  </definition>
</definitions>


### Troubleshooting

<definitions>
  <definition term="debug (default false)">
    Setting it to `true` will enable the debug logging.
  </definition>
  <definition term="debug.output (default err)">
    The destination of the debug logs. By default, they are sent to standard error. Value `out` will redirect the logging to standard output. A file path can also be specified.
  </definition>
</definitions>


### Additional

<definitions>
  <definition term="validate.properties (default true)">
    If disabled, it will ignore any misspellings or unrecognizable properties. When enabled, an exception will be thrown if the provided property cannot be recognized.
  </definition>
</definitions>

To put all of it together, the following URL:
```text
jdbc:es://http://server:3456/?timezone=UTC&page.size=250
```

opens up a Elasticsearch SQL connection to `server` on port `3456`, setting the JDBC connection timezone to `UTC` and its pagesize to `250` entries.