﻿---
title: Frozen indices
description: By default, Elasticsearch SQL doesn't search frozen indices. To search frozen indices, use one of the following features: Unless enabled, frozen indices...
url: https://www.elastic.co/docs/reference/query-languages/sql/sql-index-frozen
products:
  - Elasticsearch
---

# Frozen indices
By default, Elasticsearch SQL doesn't search frozen indices. To search frozen indices, use one of the following features:
<definitions>
  <definition term="dedicated configuration parameter">
    Set to `true` properties `index_include_frozen` in the [SQL search API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-sql-query) or `index.include.frozen` in the drivers to include frozen indices.
  </definition>
  <definition term="dedicated keyword">
    Explicitly perform the inclusion through the dedicated `FROZEN` keyword in the `FROM` clause or `INCLUDE FROZEN` in the `SHOW` commands:
  </definition>
</definitions>

```sql
SHOW TABLES INCLUDE FROZEN;

 catalog       |     name      | type     |     kind
---------------+---------------+----------+---------------
javaRestTest      |archive        |TABLE     |FROZEN INDEX
javaRestTest      |emp            |TABLE     |INDEX
javaRestTest      |employees      |VIEW      |ALIAS
javaRestTest      |library        |TABLE     |INDEX
```

```sql
SELECT * FROM FROZEN archive LIMIT 1;

     author      |        name        |  page_count   |    release_date
-----------------+--------------------+---------------+--------------------
James S.A. Corey |Leviathan Wakes     |561            |2011-06-02T00:00:00Z
```

Unless enabled, frozen indices are completely ignored; it is as if they do not exist and as such, queries ran against them are likely to fail.