﻿---
title: Getting started with SQL
description: To start using Elasticsearch SQL, create an index with some data to experiment with: And now you can execute SQL using the SQL search API: Which should...
url: https://www.elastic.co/docs/reference/query-languages/sql/sql-getting-started
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Getting started with SQL
To start using Elasticsearch SQL, create an index with some data to experiment with:
```json

{"index":{"_id": "Leviathan Wakes"}}
{"name": "Leviathan Wakes", "author": "James S.A. Corey", "release_date": "2011-06-02", "page_count": 561}
{"index":{"_id": "Hyperion"}}
{"name": "Hyperion", "author": "Dan Simmons", "release_date": "1989-05-26", "page_count": 482}
{"index":{"_id": "Dune"}}
{"name": "Dune", "author": "Frank Herbert", "release_date": "1965-06-01", "page_count": 604}
```

And now you can execute SQL using the [SQL search API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-sql-query):
```json

{
  "query": "SELECT * FROM library WHERE release_date < '2000-01-01'"
}
```

Which should return something along the lines of:
```text
    author     |     name      |  page_count   | release_date
---------------+---------------+---------------+------------------------
Dan Simmons    |Hyperion       |482            |1989-05-26T00:00:00.000Z
Frank Herbert  |Dune           |604            |1965-06-01T00:00:00.000Z
```

You can also use the [*SQL CLI*](https://www.elastic.co/docs/reference/query-languages/sql/sql-cli). There is a script to start it shipped in the Elasticsearch `bin` directory:
```bash
$ ./bin/elasticsearch-sql-cli
```

From there you can run the same query:
```sql
sql> SELECT * FROM library WHERE release_date < '2000-01-01';
    author     |     name      |  page_count   | release_date
---------------+---------------+---------------+------------------------
Dan Simmons    |Hyperion       |482            |1989-05-26T00:00:00.000Z
Frank Herbert  |Dune           |604            |1965-06-01T00:00:00.000Z
```