﻿---
title: Type conversion functions
description: Functions for converting an expression of one data type to another. Description: Casts the result of the given expression to the target data type. If...
url: https://www.elastic.co/docs/reference/query-languages/sql/sql-functions-type-conversion
products:
  - Elasticsearch
---

# Type conversion functions
Functions for converting an expression of one data type to another.

## `CAST`

```sql
CAST(
    expression 
 AS data_type) 
```

**Description**: Casts the result of the given expression to the target [data type](https://www.elastic.co/docs/reference/query-languages/sql/sql-data-types). If the cast is not possible (for example because of target type is too narrow or because the value itself cannot be converted), the query fails.
```sql
SELECT CAST('123' AS INT) AS int;

      int
---------------
123
```

```sql
SELECT CAST(123 AS VARCHAR) AS string;

    string
---------------
123
```

```sql
SELECT YEAR(CAST('2018-05-19T11:23:45Z' AS TIMESTAMP)) AS year;

     year
---------------
2018
```

<important>
  Both ANSI SQL and Elasticsearch SQL types are supported with the former taking precedence. This only affects `FLOAT` which due naming conflict, is interpreted as ANSI SQL and thus maps to `double` in Elasticsearch as oppose to `float`. To obtain an Elasticsearch `float`, perform casting to its SQL equivalent, `real` type.
</important>


## `CONVERT`

```sql
CONVERT(
    expression, 
    data_type)  
```

**Description**: Works exactly like [`CAST`](#sql-functions-type-conversion-cast) with slightly different syntax. Moreover, apart from the standard [data types](https://www.elastic.co/docs/reference/query-languages/sql/sql-data-types) it supports the corresponding [ODBC data types](https://docs.microsoft.com/en-us/sql/odbc/reference/appendixes/explicit-data-type-conversion-function?view=sql-server-2017).
```sql
SELECT CONVERT('123', SQL_INTEGER) AS int;

      int
---------------
123
```

```sql
SELECT CONVERT('123', INTEGER) AS int;

      int
---------------
123
```