﻿---
title: System functions
description: These functions return metadata type of information about the system being queried. Input: none Output: string Description: Returns the name of the database...
url: https://www.elastic.co/docs/reference/query-languages/sql/sql-functions-system
products:
  - Elasticsearch
---

# System functions
These functions return metadata type of information about the system being queried.

## `DATABASE`

```sql
DATABASE()
```

**Input**: *none*
**Output**: string
**Description**: Returns the name of the database being queried. In the case of Elasticsearch SQL, this is the name of the Elasticsearch cluster. This function should always return a non-null value.
```sql
SELECT DATABASE();

   DATABASE
---------------
elasticsearch
```


## `USER`

```sql
USER()
```

**Input**: *none*
**Output**: string
**Description**: Returns the username of the authenticated user executing the query. This function can return `null` in case [security](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/installing-elasticsearch) is disabled.
```sql
SELECT USER();

     USER
---------------
elastic
```