﻿---
title: SQL client applications
description: Thanks to its JDBC and ODBC interfaces, a broad range of third-party applications can use Elasticsearch's SQL capabilities. This section lists, in alphabetical...
url: https://www.elastic.co/docs/reference/query-languages/sql/sql-client-apps
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# SQL client applications
Thanks to its [JDBC](https://www.elastic.co/docs/reference/query-languages/sql/sql-jdbc) and [ODBC](https://www.elastic.co/docs/reference/query-languages/sql/sql-odbc) interfaces, a broad range of third-party applications can use Elasticsearch's SQL capabilities. This section lists, in alphabetical order, a number of them and their respective configuration - the list however is by no means comprehensive (feel free to [submit a PR](https://www.elastic.co/blog/art-of-pull-request) to improve it): as long as the app can use the Elasticsearch SQL driver, it can use
Elasticsearch SQL.
- [DBeaver](https://www.elastic.co/docs/reference/query-languages/sql/sql-client-apps-dbeaver)
- [DbVisualizer](https://www.elastic.co/docs/reference/query-languages/sql/sql-client-apps-dbvis)
- [Microsoft Excel](https://www.elastic.co/docs/reference/query-languages/sql/sql-client-apps-excel)
- [Microsoft Power BI Desktop](https://www.elastic.co/docs/reference/query-languages/sql/sql-client-apps-powerbi)
- [Microsoft PowerShell](https://www.elastic.co/docs/reference/query-languages/sql/sql-client-apps-ps1)
- [MicroStrategy Desktop](https://www.elastic.co/docs/reference/query-languages/sql/sql-client-apps-microstrat)
- [Qlik Sense Desktop](https://www.elastic.co/docs/reference/query-languages/sql/sql-client-apps-qlik)
- [SQuirreL SQL](https://www.elastic.co/docs/reference/query-languages/sql/sql-client-apps-squirrel)
- [SQL Workbench](https://www.elastic.co/docs/reference/query-languages/sql/sql-client-apps-workbench)
- [Tableau Desktop](https://www.elastic.co/docs/reference/query-languages/sql/sql-client-apps-tableau-desktop)
- [Tableau Server](https://www.elastic.co/docs/reference/query-languages/sql/sql-client-apps-tableau-server)

<important>
  Elastic does not endorse, promote or provide support for any of the applications listed. For native Elasticsearch integration in these products, reach out to their respective vendor.
</important>

<note>
  Each application has its own requirements and license these are outside the scope of this documentation which covers only the configuration aspect with Elasticsearch SQL.
</note>

<warning>
  The support for applications implementing the ODBC 2.x standard and prior is currently limited.
</warning>