﻿---
title: Tableau Server
description: Use the Elasticsearch JDBC driver and dedicated Elasticsearch Tableau Connector to access Elasticsearch data from Tableau Server. Tableau Server 2019.4...
url: https://www.elastic.co/docs/reference/query-languages/sql/sql-client-apps-tableau-server
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Tableau Server
Use the Elasticsearch JDBC driver and dedicated Elasticsearch Tableau Connector to access Elasticsearch data from Tableau Server.
<important>
  Elastic does not endorse, promote or provide support for this application; for native Elasticsearch integration in this product, reach out to its vendor.
</important>


## Prerequisites

- [Tableau Server](https://www.tableau.com/products/server) 2019.4 or later
- Elasticsearch SQL [JDBC driver](https://www.elastic.co/docs/reference/query-languages/sql/sql-jdbc)
- [Elasticsearch Connector for Tableau](https://www.elastic.co/downloads/tableau-connector)


## Load data

First, move or download the JDBC driver to the Tableau Server drivers directory:
- Windows: `C:\Program Files\Tableau\Drivers`
- Mac: `/Users/[user]/Library/Tableau/Drivers`

Move the Elasticsearch Connector for Tableau to the Tableau Server connectors directory. To find the location of this directory, refer to Tableau Server documentation or use the TSM command line interface.
Restart Tableau Server.
To load data into a workbook, add a **New Data Source** from the **Data** menu or using the icon. In the **Connectors** tab of the **Connect to Data** modal, select **Elasticsearch by Elastic**.

![Select Elasticsearch as the data source](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_tableau_server_from_connector.png)
Enter the information for your Elasticsearch instance, and click **Sign In**.

![Sign in](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_tableau_server_connect.png)
In the main window, select your Elasticsearch instance as the **Database**. Then select a table to load.

![Select a table to load](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_tableau_server_prepare.png)
Finally, generate a report.

![Generate a report](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_tableau_server_report.png)