﻿---
title: Tableau Desktop
description: Use the Elasticsearch JDBC driver and dedicated Elasticsearch Tableau Connector to access Elasticsearch data from Tableau Desktop. Tableau Desktop 2019.4...
url: https://www.elastic.co/docs/reference/query-languages/sql/sql-client-apps-tableau-desktop
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Tableau Desktop
Use the Elasticsearch JDBC driver and dedicated Elasticsearch Tableau Connector to access Elasticsearch data from Tableau Desktop.
<important>
  Elastic does not endorse, promote or provide support for this application; for native Elasticsearch integration in this product, reach out to its vendor.
</important>


## Prerequisites

- [Tableau Desktop](https://www.tableau.com/products/desktop) 2019.4 or later
- Elasticsearch SQL [JDBC driver](https://www.elastic.co/docs/reference/query-languages/sql/sql-jdbc)
- [Elasticsearch Connector for Tableau](https://www.elastic.co/downloads/tableau-connector)


## Load data

First, move or download the JDBC driver to the Tableau Desktop drivers directory:
- Windows: `C:\Program Files\Tableau\Drivers`
- Mac: `/Users/[user]/Library/Tableau/Drivers`

Move the Elasticsearch Connector for Tableau to the Tableau Desktop connectors directory:
- Windows: `C:\Users\[Windows User]\Documents\My Tableau Repository\Connectors`
- Mac: `/Users/[user]/Documents/My Tableau Repository/Connectors`

Launch Tableau Desktop. In the menu, click **More…** and select **Elasticsearch by Elastic** as the data source.

![Select Elasticsearch by Elastic as the data source](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_tableau_desktop_from_connector.png)
In the **New connection** modal, enter the information for your Elasticsearch instance, and click **Sign In**.

![Sign in](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_tableau_desktop_connect.png)
In the main window, select your Elasticsearch instance as the **Database**. Then select a table to load.

![Select a table to load](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_tableau_desktop_prepare.png)
Finally, generate a report.

![Generate a report](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_tableau_desktop_report.png)