﻿---
title: SQuirreL SQL
description: You can use the Elasticsearch JDBC driver to access Elasticsearch data from SQuirreL SQL. SQuirreL SQL version 4.0.0 or higher, Elasticsearch SQL JDBC...
url: https://www.elastic.co/docs/reference/query-languages/sql/sql-client-apps-squirrel
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# SQuirreL SQL
You can use the Elasticsearch JDBC driver to access Elasticsearch data from SQuirreL SQL.
<important>
  Elastic does not endorse, promote or provide support for this application; for native Elasticsearch integration in this product, reach out to its vendor.
</important>


## Prerequisites

- [SQuirreL SQL](http://squirrel-sql.sourceforge.net/) version 4.0.0 or higher
- Elasticsearch SQL [JDBC driver](https://www.elastic.co/docs/reference/query-languages/sql/sql-jdbc)


## Add Elasticsearch JDBC Driver

To add the Elasticsearch JDBC driver, use **Windows** > **View Drivers** menu (or Ctrl+Shift+D shortcut):
![squirell 1 view drivers](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-squirell-1-view-drivers.png)
Select **Elasticsearch** profile from the `Drivers` panel on the left-hand side (if it is missing check the SQuirreL SQL version or add a new entry to the list through the + button in the upper left corner):
![squirell 2 select driver](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-squirell-2-select-driver.png)
Select the **Extra Class Path** tab and **Add** the JDBC jar. Name the connection and **List Drivers** to have `Class Name` populated if it is not already filled-in :
![squirell 3 add driver](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-squirell-3-add-driver.png)
The driver should now appear in the list with a blue check mark next to its name:
![squirell 4 driver list](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-squirell-4-driver-list.png)

## Add an alias for Elasticsearch

Add a new connection or in SQuirreL terminology an *alias* using the new driver. To do so, select the **Aliases** panel on the left and click the `+` sign:
![squirell 5 add alias](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-squirell-5-add-alias.png)
Name the new alias and select the `Elasticsearch` driver previously added:
![squirell 6 alias props](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-squirell-6-alias-props.png)
The setup is completed. Double check it by clicking on **Test Connection**.

## Execute SQL queries

The connection should open automatically (if it has been created before simply click on **Connect** in the **Alias** panel). SQuirreL SQL can now issue SQL commands to Elasticsearch:
![squirell 7 data](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-squirell-7-data.png)