﻿---
title: Qlik Sense Desktop
description: You can use the Elasticsearch ODBC driver to access Elasticsearch data from Qlik Sense Desktop. Qlik Sense Desktop November 2018 or higher. You must have...
url: https://www.elastic.co/docs/reference/query-languages/sql/sql-client-apps-qlik
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Qlik Sense Desktop
You can use the Elasticsearch ODBC driver to access Elasticsearch data from Qlik Sense Desktop.
<important>
  Elastic does not endorse, promote or provide support for this application; for native Elasticsearch integration in this product, reach out to its vendor.
</important>


## Prerequisites

- [Qlik Sense Desktop](https://community.qlik.com/t5/Download-Qlik-Products/tkb-p/Downloads) November 2018 or higher. You must have a Qlik account to download it.
- Elasticsearch SQL [ODBC driver](https://www.elastic.co/docs/reference/query-languages/sql/sql-odbc)
- A preconfigured User or System DSN (see [Configuration](/docs/reference/query-languages/sql/sql-odbc-setup#dsn-configuration) section on how to configure a DSN).


## Data loading

To use the Elasticsearch SQL ODBC Driver to load data into Qlik Sense Desktop perform the following steps in sequence.
1. Create new app
   Once the application is launched, you’ll first need to click on the *Create new app* button:
   ![apps qlik newapp](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_qlik_newapp.png)
2. Name app
   …then give it a name,
   ![apps qlik create](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_qlik_create.png)
3. Open app
   …and then open it:
   ![apps qlik open](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_qlik_open.png)
4. Add data to your app
   Start configuring the source to load data from in the newly created app:
   ![apps qlik adddata](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_qlik_adddata.png)
5. Load from ODBC
   You’ll be given a choice of sources to select. Click on the *ODBC* icon:
   ![apps qlik odbc](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_qlik_odbc.png)
6. Choose DSN
   In the *Create new connection (ODBC)* dialog, click on the DSN name that you have previously configured for your Elasticsearch instance:
   ![apps qlik dsn](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_qlik_dsn.png)
   Provide a username and password in the respective fields, if authentication is enabled on your instance and if these are not already part of the DSN. Press the *Create* button.
7. Select source table
   The application will now connect to the Elasticsearch instance and query the catalog information, presenting you with a list of tables that you can load data from:
   ![apps qlik selecttable](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_qlik_selecttable.png)
8. Visualize the data
   Press on the *Add data* button and customize your data visualization:
   ![apps qlik visualize](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_qlik_visualize.png)