﻿---
title: Microsoft Power BI Desktop
description: You can use the Elasticsearch ODBC driver to access Elasticsearch data from Microsoft Power BI Desktop. Microsoft Power BI Desktop 2.63 or higher, Elasticsearch...
url: https://www.elastic.co/docs/reference/query-languages/sql/sql-client-apps-powerbi
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Microsoft Power BI Desktop
You can use the Elasticsearch ODBC driver to access Elasticsearch data from Microsoft Power BI Desktop.
<important>
  Elastic does not endorse, promote or provide support for this application; for native Elasticsearch integration in this product, reach out to its vendor.
</important>


## Prerequisites

- [Microsoft Power BI Desktop](https://powerbi.microsoft.com/en-us/desktop/) 2.63 or higher
- Elasticsearch SQL [ODBC driver](https://www.elastic.co/docs/reference/query-languages/sql/sql-odbc)
- A preconfigured User or System DSN (see [Configuration](/docs/reference/query-languages/sql/sql-odbc-setup#dsn-configuration) section on how to configure a DSN).


## Data loading

First, you’ll need to choose ODBC as the source to load data from. Once launched, click on the *Get Data* button (under *Home* tab), then on the *More…* button at the bottom of the list:

![apps pbi fromodbc1](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_pbi_fromodbc1.png)
In the new opened window scroll at the bottom of the *All* list and select the *ODBC* entry, then click on the *Connect* button:

![apps pbi fromodbc2](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_pbi_fromodbc2.png)
This will replace current window with a new *From ODBC* one, where you’ll have to select a previously configured DSN:

![apps pbi dsn](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_pbi_dsn.png)
Once connected Power BI will read Elasticsearch's catalog and offer the user a choice of tables (indices) to load data from. Clicking on one of the tables will load a preview of the data within:

![apps pbi picktable](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_pbi_picktable.png)
Now tick the chosen table and click on the *Load* button. Power BI will now load and analyze the data, populating a list with the available columns. These can now be used to build the desired visualisation:

![apps pbi loaded](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_pbi_loaded.png)