﻿---
title: MicroStrategy Desktop
description: You can use the Elasticsearch ODBC driver to access Elasticsearch data from MicroStrategy Desktop. MicroStrategy Desktop 11 or higher, Elasticsearch SQL...
url: https://www.elastic.co/docs/reference/query-languages/sql/sql-client-apps-microstrat
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# MicroStrategy Desktop
You can use the Elasticsearch ODBC driver to access Elasticsearch data from MicroStrategy Desktop.
<important>
  Elastic does not endorse, promote or provide support for this application; for native Elasticsearch integration in this product, reach out to its vendor.
</important>


## Prerequisites

- [MicroStrategy Desktop](https://www.microstrategy.com/us/get-started/desktop) 11 or higher
- Elasticsearch SQL [ODBC driver](https://www.elastic.co/docs/reference/query-languages/sql/sql-odbc)
- A preconfigured User or System DSN (see [Configuration](/docs/reference/query-languages/sql/sql-odbc-setup#dsn-configuration) section on how to configure a DSN).


## Data loading

To use the Elasticsearch SQL ODBC Driver to load data into MicroStrategy Desktop perform the following steps in sequence.
1. Create a New Dossier
   Once the application is launched, you’ll first need to create a *New Dossier*:
   ![apps microstrat newdossier](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_microstrat_newdossier.png)
2. New Data
   To import into the *New Dossier* just opened, press on the *New Data* button in the *DATASETS* column:
   ![apps microstrat newdata](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_microstrat_newdata.png)
3. Access data from Tables
   This opens a new window that allows to choose the source to load data from. Click on the *Databases* icon:
   ![apps microstrat databases](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_microstrat_databases.png)
4. New Data Source
   In the newly opened *Import from Table - Select* window, click on the **+** button to the right of *DATA SOURCES* item:
   ![apps microstrat newds](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_microstrat_newds.png)
5. Data Source
   In the *Data Source* window, tick the radio button for *DSN Data Sources*. In the *DSN* drop-down box, choose the name of the DSN that you have previously configured. For the *Version*, chose *Generic DBMS*.
   Input a user name and password in the provided fields. Note that the application requires them irrespective of the fact that they might already be part of the previously configured DSN and the new input will take precedence over those.
   Finally, give a name to the application-specific data source you’re just configuring:
   ![apps microstrat dsn](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_microstrat_dsn.png)
6. Select Import Options
   Choosing an import methodology follows. You can pick any of the options; we’ll exemplify the *Select Tables* option:
   ![apps microstrat tables](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_microstrat_tables.png)
7. Import from Table - Select
   The data source you’ve named two steps before is now listed in the *DATA SOURCES* column. Clicking on its name triggers the application to query the Elasticsearch instance configured in the DSN and list the tables available within:
   ![apps microstrat loadtable](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_microstrat_loadtable.png)
8. Data Access Mode
   Choose a table to load data from and press the *Finish* button. When doing so, the application offers to choose a loading methodology. You can choose whichever, we’ll exemplify the *Connect Live* way:
   ![apps microstrat live](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_microstrat_live.png)
9. Visualize the data
   From the *DATASETS* column you can choose what table columns (or index fields) to visualize:
   ![apps microstrat visualize](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_microstrat_visualize.png)