﻿---
title: Microsoft Excel
description: You can use the Elasticsearch ODBC driver to access Elasticsearch data from Microsoft Excel. Microsoft Office 2016 or higher, Elasticsearch SQL ODBC driver,...
url: https://www.elastic.co/docs/reference/query-languages/sql/sql-client-apps-excel
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Microsoft Excel
You can use the Elasticsearch ODBC driver to access Elasticsearch data from Microsoft Excel.
<important>
  Elastic does not endorse, promote or provide support for this application; for native Elasticsearch integration in this product, reach out to its vendor.
</important>


## Prerequisites

- [Microsoft Office](https://products.office.com/en/excel) 2016 or higher
- Elasticsearch SQL [ODBC driver](https://www.elastic.co/docs/reference/query-languages/sql/sql-odbc)
- A preconfigured User or System DSN (see [Configuration](/docs/reference/query-languages/sql/sql-odbc-setup#dsn-configuration) section on how to configure a DSN).


## Load data into a spreadsheet

First, you’ll need to choose ODBC as the source to load data from. To do so, click on the *Data* tab, then *New Query* button, in the drop-down menu expand *From Other Sources*, then choose *From ODBC*:

![apps excel fromodbc](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_excel_fromodbc.png)
This will open a new window with a drop down menu populated with the DSNs that Excel found on the system. Choose a DSN configured to connect to your Elasticsearch instance and press the *OK* button:

![apps excel dsn](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_excel_dsn.png)
This will lead to a new window, allowing the user to input the connection credentials.
A username might be required by Excel even if the Elasticsearch instance has no security enabled. Providing a bogus username with no password in this case will not hinder the connectivity. Note however that Excel will cache these credentials (so in case you do have security enabled, you won’t be prompted for the credentials a second time).
Fill in the username and the password and press *Connect*.

![apps excel cred](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_excel_cred.png)
Once connected, Excel will read Elasticsearch's catalog and offer the user a choice of tables (indices) to load data from. Clicking on one of the tables will load a preview of the data within:

![apps excel picktable](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_excel_picktable.png)
Now click the *Load* button, which will have Excel load all the data from the table into a spreadsheet:

![apps excel loaded](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-apps_excel_loaded.png)