﻿---
title: DbVisualizer
description: You can use the Elasticsearch JDBC driver to access Elasticsearch data from DbVisualizer. DbVisualizer 13.0 or higher, Elasticsearch SQL JDBC driver. 
url: https://www.elastic.co/docs/reference/query-languages/sql/sql-client-apps-dbvis
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# DbVisualizer
You can use the Elasticsearch JDBC driver to access Elasticsearch data from DbVisualizer.
<important>
  Elastic does not endorse, promote or provide support for this application.
</important>


## Prerequisites

- [DbVisualizer](https://www.dbvis.com/) 13.0 or higher
- Elasticsearch SQL [JDBC driver](https://www.elastic.co/docs/reference/query-languages/sql/sql-jdbc)
  <definitions>
  <definition term="Note">
  Pre 13.0 versions of DbVisualizer can still connect to Elasticsearch by having the [JDBC driver](https://www.elastic.co/docs/reference/query-languages/sql/sql-jdbc) set up from the generic **Custom** template.
  </definition>
  </definitions>


## Setup the Elasticsearch JDBC driver

Setup the Elasticsearch JDBC driver through **Tools** > **Driver Manager**:
![dbvis driver manager](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-dbvis_open_driver_manager.png)
Select **Elasticsearch** driver template from the left sidebar to create a new user driver:
![dbvis driver manager elasticsearch](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-dbvis_new_driver_done.png)
Download the driver locally:
![dbvis driver manager download](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-dbvis_new_driver_start.png)
and check its availability status:
![dbvis driver manager ready](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-dbvis_new_driver_refresh.png)

## Create a new connection

Once the Elasticsearch driver is in place, create a new connection:
![dbvis new connection](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-dbvis_add_db_connection.png)
by double-clicking the Elasticsearch entry in the list of available drivers:
![dbvis new elasticsearch connection](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-dbvis_add_connection.png)
Enter the connection details, then press **Connect** and the driver version (as that of the cluster) should show up under **Connection Message**.
![dbvis enter connection details](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-dbvis_connection_details.png)

## Execute SQL queries

The setup is done. DbVisualizer can be used to run queries against Elasticsearch and explore its content:
![dbvis running queries](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-dbvis_hero.png)