﻿---
title: DBeaver
description: You can use the Elasticsearch JDBC driver to access Elasticsearch data from DBeaver. DBeaver version 6.0.0 or higher, Elasticsearch SQL JDBC driver. Create...
url: https://www.elastic.co/docs/reference/query-languages/sql/sql-client-apps-dbeaver
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# DBeaver
You can use the Elasticsearch JDBC driver to access Elasticsearch data from DBeaver.
<important>
  Elastic does not endorse, promote or provide support for this application; for native Elasticsearch integration in this product, reach out to its vendor.
</important>


## Prerequisites

- [DBeaver](https://dbeaver.io/) version 6.0.0 or higher
- Elasticsearch SQL [JDBC driver](https://www.elastic.co/docs/reference/query-languages/sql/sql-jdbc)


## New Connection

Create a new connection either through the menu **File** > **New** > **Database Connection** menu or directly through the **Database Connection** panel.
![dbeaver 1 new conn](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-dbeaver-1-new-conn.png)

## Select Elasticsearch type

Select the Elasticsearch type from the available connection types:
![dbeaver 2 conn es](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-dbeaver-2-conn-es.png)

## Specify the Elasticsearch cluster information

Configure the Elasticsearch SQL connection appropriately:
![dbeaver 3 conn props](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-dbeaver-3-conn-props.png)

## Verify the driver version

Make sure the correct JDBC driver version is used by using the **Edit Driver Settings** button:
![dbeaver 4 driver ver](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-dbeaver-4-driver-ver.png)
DBeaver is aware of the Elasticsearch JDBC maven repository so simply **Download/Update** the artifact or add a new one. As an alternative one can add a local file instead if the Elasticsearch Maven repository is not an option.
When changing the driver, make sure to click on the **Find Class** button at the bottom - the Driver class should be picked out automatically however this provides a sanity check that the driver jar is properly found and it is not corrupt.

## Test connectivity

Once the driver version and the settings are in place, use **Test Connection** to check that everything works. If things are okay, one should get a confirmation window with the version of the driver and that of Elasticsearch SQL:
![dbeaver 5 test conn](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-dbeaver-5-test-conn.png)
Click **Finish** and the new Elasticsearch connection appears in the **Database Connection** panel.
DBeaver is now configured to talk to Elasticsearch.

## Connect to Elasticsearch

Simply click on the Elasticsearch connection and start querying and exploring Elasticsearch:
![dbeaver 6 data](https://www.elastic.co/docs/reference/query-languages/images/elasticsearch-reference-dbeaver-6-data.png)