﻿---
title: Run an async SQL search
description: By default, SQL searches are synchronous. They wait for complete results before returning a response. However, results can take longer for searches across...
url: https://www.elastic.co/docs/reference/query-languages/sql/sql-async
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Run an async SQL search
By default, SQL searches are synchronous. They wait for complete results before returning a response. However, results can take longer for searches across large data sets or [frozen data](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers).
To avoid long waits, run an async SQL search. Set `wait_for_completion_timeout` to a duration you’d like to wait for synchronous results.
```json

{
  "wait_for_completion_timeout": "2s",
  "query": "SELECT * FROM library ORDER BY page_count DESC",
  "fetch_size": 5
}
```

If the search doesn’t finish within this period, the search becomes async. The API returns:
- An `id` for the search.
- An `is_partial` value of `true`, indicating the search results are incomplete.
- An `is_running` value of `true`, indicating the search is still running in the background.

For CSV, TSV, and TXT responses, the API returns these values in the respective `Async-ID`, `Async-partial`, and `Async-running` HTTP headers instead.
```json
{
  "id": "FnR0TDhyWUVmUmVtWXRWZER4MXZiNFEad2F5UDk2ZVdTVHV1S0xDUy00SklUdzozMTU=",
  "is_partial": true,
  "is_running": true,
  "rows": [ ]
}
```

To check the progress of an async search, use the search ID with the [get async SQL search status API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-sql-get-async-status).
```json
```

If `is_running` and `is_partial` are `false`, the async search has finished with complete results.
```json
{
  "id": "FnR0TDhyWUVmUmVtWXRWZER4MXZiNFEad2F5UDk2ZVdTVHV1S0xDUy00SklUdzozMTU=",
  "is_running": false,
  "is_partial": false,
  "expiration_time_in_millis": 1611690295000,
  "completion_status": 200
}
```

To get the results, use the search ID with the [get async SQL search API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-sql-get-async). If the search is still running, specify how long you’d like to wait using `wait_for_completion_timeout`. You can also specify the response `format`.
```json
```


## Change the search retention period

By default, Elasticsearch stores async SQL searches for five days. After this period, Elasticsearch deletes the search and its results, even if the search is still running. To change this retention period, use the `keep_alive` parameter.
```json

{
  "keep_alive": "2d",
  "wait_for_completion_timeout": "2s",
  "query": "SELECT * FROM library ORDER BY page_count DESC",
  "fetch_size": 5
}
```

You can use the get async SQL search API’s `keep_alive` parameter to later change the retention period. The new period starts after the request runs.
```json
```

Use the [delete async SQL search API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-sql-delete-async) to delete an async search before the `keep_alive` period ends. If the search is still running, Elasticsearch cancels it.
```json
```


## Store synchronous SQL searches

By default, Elasticsearch only stores async SQL searches. To save a synchronous search, specify `wait_for_completion_timeout` and set `keep_on_completion` to `true`.
```json

{
  "keep_on_completion": true,
  "wait_for_completion_timeout": "2s",
  "query": "SELECT * FROM library ORDER BY page_count DESC",
  "fetch_size": 5
}
```

If `is_partial` and `is_running` are `false`, the search was synchronous and returned complete results.
```json
{
  "id": "Fnc5UllQdUVWU0NxRFNMbWxNYXplaFEaMUpYQ05oSkpTc3kwZ21EdC1tbFJXQTo0NzA=",
  "is_partial": false,
  "is_running": false,
  "rows": ...,
  "columns": ...,
  "cursor": ...
}
```

You can get the same results later using the search ID with the [get async SQL search API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-sql-get-async).
Saved synchronous searches are still subject to the `keep_alive` retention period. When this period ends, Elasticsearch deletes the search results. You can also delete saved searches using the [delete async SQL search API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-sql-delete-async).