﻿---
title: QueryDSL
description: Elasticsearch provides a full Query DSL (Domain Specific Language) based on JSON to define queries. Think of the Query DSL as an AST (Abstract Syntax...
url: https://www.elastic.co/docs/reference/query-languages/querydsl
products:
  - Elasticsearch
---

# QueryDSL
<note>
  Refer to the [Query DSL overview](https://www.elastic.co/docs/explore-analyze/query-filter/languages/querydsl) in the **Explore and analyze** section for overview and conceptual information about Query DSL.
</note>

Elasticsearch provides a full Query DSL (Domain Specific Language) based on JSON to define queries. Think of the Query DSL as an AST (Abstract Syntax Tree) of queries, consisting of two types of clauses:
<definitions>
  <definition term="Leaf query clauses">
    Leaf query clauses look for a particular value in a particular field, such as the [`match`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-match-query), [`term`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-term-query) or [`range`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-range-query) queries. These queries can be used by themselves.
  </definition>
  <definition term="Compound query clauses">
    Compound query clauses wrap other leaf **or** compound queries and are used to combine multiple queries in a logical fashion (such as the [`bool`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-bool-query) or [`dis_max`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-dis-max-query) query), or to alter their behaviour (such as the [`constant_score`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-constant-score-query) query).
  </definition>
</definitions>

Query clauses behave differently depending on whether they are used in [query context or filter context](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-filter-context).

<definitions>
  <definition term="Allow expensive queries">
    Certain types of queries will generally execute slowly due to the way they are implemented, which can affect the stability of the cluster. Those queries can be categorised as follows:
    - Queries that need to do linear scans to identify matches:
      - [`script` queries](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-script-query)
    - queries on [numeric](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/number), [date](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/date), [boolean](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/boolean), [ip](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/ip), [geo_point](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/geo-point) or [keyword](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/keyword) fields that are not indexed but have [doc values](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/doc-values) enabled
    - Queries that have a high up-front cost:
      - [`fuzzy` queries](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-fuzzy-query) (except on [`wildcard`](/docs/reference/elasticsearch/mapping-reference/keyword#wildcard-field-type) fields)
    - [`regexp` queries](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-regexp-query) (except on [`wildcard`](/docs/reference/elasticsearch/mapping-reference/keyword#wildcard-field-type) fields)
    - [`prefix` queries](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-prefix-query)  (except on [`wildcard`](/docs/reference/elasticsearch/mapping-reference/keyword#wildcard-field-type) fields or those without [`index_prefixes`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/index-prefixes))
    - [`wildcard` queries](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-wildcard-query) (except on [`wildcard`](/docs/reference/elasticsearch/mapping-reference/keyword#wildcard-field-type) fields)
    - [`range` queries](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-range-query) on [`text`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/text) and [`keyword`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/keyword) fields
    - [Joining queries](https://www.elastic.co/docs/reference/query-languages/query-dsl/joining-queries)
    - Queries that may have a high per-document cost:
      - [`script_score` queries](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-script-score-query)
    - [`percolate` queries](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-percolate-query)
  </definition>
</definitions>

The execution of such queries can be prevented by setting the value of the `search.allow_expensive_queries` setting to `false` (defaults to `true`).