﻿---
title: Term-level queries
description: You can use term-level queries to find documents based on precise values in structured data. Examples of structured data include date ranges, IP addresses,...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/term-level-queries
products:
  - Elasticsearch
---

# Term-level queries
You can use **term-level queries** to find documents based on precise values in structured data. Examples of structured data include date ranges, IP addresses, prices, or product IDs.
Unlike [full-text queries](https://www.elastic.co/docs/reference/query-languages/query-dsl/full-text-queries), term-level queries do not analyze search terms. Instead, term-level queries match the exact terms stored in a field.
<note>
  Term-level queries still normalize search terms for `keyword` fields with the `normalizer` property. For more details, see [`normalizer`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/normalizer).
</note>


## Types of term-level queries

<definitions>
  <definition term="exists query">
    Returns documents that contain any indexed value for a field.
  </definition>
  <definition term="fuzzy query">
    Returns documents that contain terms similar to the search term. Elasticsearch measures similarity, or fuzziness, using a [Levenshtein edit distance](https://en.wikipedia.org/wiki/Levenshtein_distance).
  </definition>
  <definition term="ids query">
    Returns documents based on their [document IDs](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-id-field).
  </definition>
  <definition term="prefix query">
    Returns documents that contain a specific prefix in a provided field.
  </definition>
  <definition term="range query">
    Returns documents that contain terms within a provided range.
  </definition>
  <definition term="regexp query">
    Returns documents that contain terms matching a [regular expression](https://en.wikipedia.org/wiki/Regular_expression).
  </definition>
  <definition term="term query">
    Returns documents that contain an exact term in a provided field.
  </definition>
  <definition term="terms query">
    Returns documents that contain one or more exact terms in a provided field.
  </definition>
  <definition term="terms_set query">
    Returns documents that contain a minimum number of exact terms in a provided field. You can define the minimum number of matching terms using a field or script.
  </definition>
  <definition term="wildcard query">
    Returns documents that contain terms matching a wildcard pattern.
  </definition>
</definitions>